/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.generator;

import com.netapp.common.generator.CodeFormatter;
import com.netapp.common.generator.NetappCodeFormatter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetappClassGenerator {
    private static final Pattern DESC_SCRUB_PATTERN = Pattern.compile("(</?(\\w+)(?:\\s+[\\w\\_]+=\"(?:[^\"]|\\\\\")*\")*>|<|>|\\\\)");
    private static Set<String> allowedHtmlTags = new HashSet<String>();
    private CodeFormatter formatter;
    private StringBuffer classBuffer = new StringBuffer();
    private StringBuffer currentIndent = new StringBuffer();
    private String packageName;
    private List<String> packageComments;
    private Set<String> imports = new TreeSet<String>();

    public NetappClassGenerator(String packageName) {
        this(packageName, new NetappCodeFormatter());
    }

    public NetappClassGenerator(String packageName, CodeFormatter formatter) {
        this.packageName = packageName;
        this.formatter = formatter;
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "DM_DEFAULT_ENCODING"})
    public final void writeCode(String dirName, String fileName) throws IOException {
        File dir = new File(dirName);
        dir.mkdirs();
        FileWriter fileWriter = new FileWriter(new File(dir, fileName));
        this.writeCode(fileWriter);
        ((Writer)fileWriter).close();
    }

    public void writeCode(Writer fileWriter) throws IOException {
        fileWriter.write(this.formatter.fileHeader() + this.formatter.newLine());
        if (this.packageComments != null && !this.packageComments.isEmpty()) {
            fileWriter.write("/**" + this.formatter.newLine());
            for (String comment : this.packageComments) {
                fileWriter.write(" * " + this.scrubJavadoc(comment) + this.formatter.newLine());
            }
            fileWriter.write(" */" + this.formatter.newLine());
        }
        fileWriter.write("package " + this.packageName + ";" + this.formatter.newLine());
        fileWriter.write(this.formatter.newLine());
        fileWriter.write("//CHECKSTYLE:OFF ImportOrder" + this.formatter.newLine());
        fileWriter.write("//CHECKSTYLE:OFF AvoidStarImport" + this.formatter.newLine());
        for (String str : this.imports) {
            fileWriter.write("import " + str + ";" + this.formatter.newLine());
        }
        fileWriter.write("//CHECKSTYLE:ON ImportOrder" + this.formatter.newLine());
        fileWriter.write("//CHECKSTYLE:ON AvoidStarImport" + this.formatter.newLine());
        fileWriter.write(this.formatter.newLine());
        fileWriter.write(this.classBuffer.toString());
        fileWriter.flush();
    }

    public StringBuffer getClassBuffer() {
        return this.classBuffer;
    }

    public void addLine(String line, Object ... args) {
        this.classBuffer.append(this.currentIndent);
        this.classBuffer.append(args.length > 0 ? String.format(line, args) : line);
        this.classBuffer.append(this.formatter.newLine());
    }

    public void addPackageJavadoc(String comment) {
        if (this.packageComments == null) {
            this.packageComments = new ArrayList<String>();
        }
        this.packageComments.add(comment);
    }

    public void addLine() {
        this.classBuffer.append(this.formatter.newLine());
    }

    protected void addGuidLine(String guid) {
        this.addLine("// " + this.formatter.guid() + " " + guid, new Object[0]);
    }

    protected String scrubJavadoc(String comment) {
        StringBuffer buffer = new StringBuffer();
        Matcher m = DESC_SCRUB_PATTERN.matcher(comment != null ? comment : "");
        while (m.find()) {
            if (m.group(2) != null && allowedHtmlTags.contains(m.group(2).toLowerCase())) {
                m.appendReplacement(buffer, m.group(1).replaceAll("\\$", "\\\\\\$"));
                continue;
            }
            String rep = m.group(1).replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\\\", "\\\\\\\\\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            m.appendReplacement(buffer, rep);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    public void addJavadoc(List<String> comments) {
        this.addLine("/**", new Object[0]);
        for (String line : comments) {
            String scrubbed = this.scrubJavadoc(line);
            for (String nl : scrubbed.split("[\\r\\n]+")) {
                this.addLine(" * " + nl, new Object[0]);
            }
        }
        this.addLine(" */", new Object[0]);
    }

    public void addJavadocLine(String comment) {
        this.addJavadoc(Collections.singletonList(comment));
    }

    public void addText(String text) {
        this.classBuffer.append(text);
    }

    public void addIndent() {
        this.classBuffer.append(this.currentIndent);
    }

    public void zeroIndent() {
        this.currentIndent.setLength(0);
    }

    public void increaseIndent() {
        this.currentIndent.append(this.formatter.tab());
    }

    public void indent() {
        this.increaseIndent();
    }

    public void decreaseIndent() {
        try {
            this.currentIndent.delete(this.currentIndent.length() - this.formatter.tab().length(), this.currentIndent.length());
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Too many decrease indents called.");
        }
    }

    public void outdent() {
        this.decreaseIndent();
    }

    public void addImport(String fullTypeName) {
        String importPackageName;
        int index = fullTypeName.lastIndexOf(46);
        if (index != -1 && !(importPackageName = fullTypeName.substring(0, index)).equals(this.packageName) && !importPackageName.equals("java.lang")) {
            this.imports.add(fullTypeName);
        }
    }

    protected String toClassName(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    protected String toVariableName(String className) {
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    protected String toJavaName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '_') continue;
            name = name.substring(0, i) + name.substring(i + 1, i + 2).toUpperCase() + name.substring(i + 2);
        }
        return name;
    }

    protected String finalPackageName(String packageName) {
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    static {
        allowedHtmlTags.add("b");
        allowedHtmlTags.add("br");
        allowedHtmlTags.add("font");
        allowedHtmlTags.add("i");
        allowedHtmlTags.add("p");
        allowedHtmlTags.add("dd");
        allowedHtmlTags.add("dl");
        allowedHtmlTags.add("dt");
        allowedHtmlTags.add("hr");
        allowedHtmlTags.add("i");
        allowedHtmlTags.add("li");
        allowedHtmlTags.add("ol");
        allowedHtmlTags.add("p");
        allowedHtmlTags.add("samp");
        allowedHtmlTags.add("table");
        allowedHtmlTags.add("tr");
        allowedHtmlTags.add("th");
        allowedHtmlTags.add("td");
        allowedHtmlTags.add("ul");
        allowedHtmlTags.add("var");
    }
}

