/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.generator;

import com.netapp.common.generator.CodeFormatter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SuppressWarnings(value={"STCAL"})
public class NetappCodeFormatter
implements CodeFormatter {
    private static final DateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final Date NOW = new Date();
    public static final String RCS_ID = "$Id$";
    protected List<String> header = new ArrayList<String>();

    public NetappCodeFormatter() {
        this.header.add(RCS_ID);
        this.header.add("");
        this.header.add("Copyright (c) " + YEAR_FORMAT.format(NOW) + " Network Appliance, Inc.");
        this.header.add("All rights reserved.");
        this.header.add("");
        this.header.add("This file was generated at " + DATE_FORMAT.format(NOW));
    }

    @Override
    public final String tab() {
        return "    ";
    }

    @Override
    public final String newLine() {
        return "\n";
    }

    @Override
    public final String fixMe() {
        return "// FIXME";
    }

    @Override
    public final String toDo() {
        return "// TODO";
    }

    @Override
    public final String defaultType() {
        return "Object";
    }

    @Override
    public String guid() {
        return "__GUID__";
    }

    public void addHeaderLine(String line) {
        this.header.add(line);
    }

    @Override
    public final String fileHeader() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("/*").append(this.newLine());
        for (String s : this.header) {
            buffer.append(" * ").append(s).append(this.newLine());
        }
        buffer.append(" */").append(this.newLine());
        return buffer.toString();
    }
}

