/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging.generator;

import com.netapp.common.logging.generator.MsgKeyGenerator;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class GenerateMsgKeys
extends Task {
    private List<FileSet> propertiesFileSets = new ArrayList<FileSet>();
    private File outputDir;
    private String enumShortName = "MsgKey";

    public void addFileset(FileSet buildFiles) {
        this.propertiesFileSets.add(buildFiles);
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setEnumShortName(String enumShortName) {
        this.enumShortName = enumShortName;
    }

    @SuppressWarnings(value={"DP"})
    public void execute() {
        if (this.propertiesFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        try {
            for (FileSet propertiesFileSet : this.propertiesFileSets) {
                DirectoryScanner scanner = propertiesFileSet.getDirectoryScanner(this.getProject());
                ArrayList<String> includedFiles = new ArrayList<String>(Arrays.asList(scanner.getIncludedFiles()));
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{scanner.getBasedir().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
                for (String includedFile : includedFiles) {
                    String enumName = this.calculateFullEnumName(includedFile);
                    File javaFile = MsgKeyGenerator.calculateJavaFileName(this.outputDir, enumName);
                    if (javaFile.lastModified() >= new File(scanner.getBasedir(), includedFile).lastModified()) {
                        this.log(String.format("NOT Generating %1$s from %2$s. %1$s is up to date.", enumName, includedFile));
                        continue;
                    }
                    this.log(String.format("Generating %s from %s", enumName, includedFile));
                    MsgKeyGenerator.generateMsgKeyToFile(includedFile, javaFile, enumName, urlClassLoader);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String calculateFullEnumName(String includedFile) {
        int lastDot;
        String enumName = includedFile;
        if (enumName.endsWith(".properties")) {
            enumName = enumName.substring(0, enumName.length() - ".properties".length());
        }
        String packageName = (lastDot = (enumName = enumName.replaceAll("(\\\\|/)", ".")).lastIndexOf(46)) == -1 ? enumName : enumName.substring(0, lastDot);
        return packageName + "." + this.enumShortName;
    }
}

