/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.common.logging.generator;

import com.netapp.common.generator.NetappClassGenerator;
import com.netapp.common.generator.NetappCodeFormatter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ClassUtils;

public final class MsgKeyGenerator
extends NetappClassGenerator {
    static final String BUNDLE_FILE_SUFFIX = ".properties";
    private static final String MSG_KEY_INTERFACE = "com.netapp.common.logging.MessageKey";
    private static final String MESSAGE_BUNDLE_CLASS = "com.netapp.common.logging.MessageBundle";
    private static final String BUNDLE_ANNOTATION = "com.netapp.common.logging.Bundle";
    private static final Pattern CODE_PATTERN = Pattern.compile("^(\\w+-\\d+):.*", 32);
    private static final NetappCodeFormatter FORMATTER = new NetappCodeFormatter();
    protected String className;
    protected String packageName;
    protected String bundleName;
    protected ResourceBundle bundle;
    protected String classData;

    public MsgKeyGenerator(String qualifiedClassName, String bundleName, ClassLoader classLoader) {
        super(ClassUtils.getPackageName((String)qualifiedClassName), FORMATTER);
        this.className = ClassUtils.getShortClassName((String)qualifiedClassName);
        if (MSG_KEY_INTERFACE.equals(qualifiedClassName)) {
            throw new RuntimeException("Generated class name may not be com.netapp.common.logging.MessageKey");
        }
        this.bundleName = (bundleName.endsWith(BUNDLE_FILE_SUFFIX) ? bundleName.substring(0, bundleName.length() - BUNDLE_FILE_SUFFIX.length()) : bundleName).replaceAll("\\\\", "/");
        this.bundle = ResourceBundle.getBundle(this.bundleName, Locale.US, classLoader);
        this.generateMsgKeyClass();
    }

    public String getClassData() {
        return this.classData;
    }

    static String toEnumString(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1).replaceAll("\\.|/|-", "_").replaceAll("([A-Z])", "_$1").toUpperCase();
    }

    private void generateMsgKeyClass() {
        this.addLine("@com.netapp.common.logging.Bundle(\"" + this.bundleName + "\")", new Object[0]);
        this.addLine("public enum " + this.className + " implements " + MSG_KEY_INTERFACE + " {", new Object[0]);
        this.increaseIndent();
        this.generateMsgEnumerations();
        this.addLine();
        this.addLine("private final String propertyName;", new Object[0]);
        this.addLine();
        this.addLine("private " + this.className + "(String propertyName) {", new Object[0]);
        this.increaseIndent();
        this.addLine("this.propertyName = propertyName;", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.addLine();
        this.addLine("@Override", new Object[0]);
        this.addLine("public String getPropertyName() {", new Object[0]);
        this.increaseIndent();
        this.addLine("return this.propertyName;", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.addLine();
        this.addLine("/**", new Object[0]);
        this.addLine(" * Localize this message key from its resource bundle.", new Object[0]);
        this.addLine(" *", new Object[0]);
        this.addLine(" * @param params Objects for variable substitution in string", new Object[0]);
        this.addLine(" * @return Localized text string", new Object[0]);
        this.addLine(" */", new Object[0]);
        this.addLine("@Override", new Object[0]);
        this.addLine("public String localize(Object... params) {", new Object[0]);
        this.increaseIndent();
        this.addLine("return com.netapp.common.logging.MessageBundle.localizeMessage(this, params);", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.addLine();
        this.addLine("/**", new Object[0]);
        this.addLine(" * Find the " + this.className + " value for the given propertyName.", new Object[0]);
        this.addLine(" *", new Object[0]);
        this.addLine(" * @param propertyName the property name within the resource bundle for which to find the key", new Object[0]);
        this.addLine(" * @return MsgKey value for the given propertyName", new Object[0]);
        this.addLine(" * @throws IllegalArgumentException if no MsgKey value exists for the propertyName", new Object[0]);
        this.addLine(" */", new Object[0]);
        this.addLine("public static " + this.className + " parseKey(String propertyName) {", new Object[0]);
        this.increaseIndent();
        this.addLine("for (" + this.className + " testKey : " + this.className + ".values()) {", new Object[0]);
        this.increaseIndent();
        this.addLine("if (testKey.propertyName.equals(propertyName)) {", new Object[0]);
        this.increaseIndent();
        this.addLine("return testKey;", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.addLine("throw new IllegalArgumentException(\"No enum found in \" + " + this.className + ".class.getName() + \" for property name \" + propertyName);", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
        this.decreaseIndent();
        this.addLine("}", new Object[0]);
    }

    private void generateMsgEnumerations() {
        HashSet<String> seenCodes = new HashSet<String>();
        HashSet<String> seenKeys = new HashSet<String>();
        ArrayList<String> bundleKeyList = new ArrayList<String>(this.bundle.keySet());
        Collections.sort(bundleKeyList);
        Iterator bundleKeyIter = bundleKeyList.iterator();
        while (bundleKeyIter.hasNext()) {
            String bundleKey = (String)bundleKeyIter.next();
            String comment = this.bundle.getString(bundleKey);
            String enumKey = MsgKeyGenerator.toEnumString(bundleKey);
            if (seenKeys.contains(enumKey)) {
                throw new RuntimeException("Duplicate enumeration key " + enumKey);
            }
            seenKeys.add(enumKey);
            Matcher matcher = CODE_PATTERN.matcher(comment);
            if (matcher.matches()) {
                String code = matcher.group(1);
                if (seenCodes.contains(code)) {
                    throw new RuntimeException("Duplicate message code " + code);
                }
                seenCodes.add(code);
            }
            this.addJavadocLine(comment);
            this.addLine(enumKey + "(\"" + bundleKey + "\")" + (bundleKeyIter.hasNext() ? "," : ";"), new Object[0]);
        }
    }

    public static String classNameToFilePath(String clazz) {
        return clazz.replace('.', File.separatorChar);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            MsgKeyGenerator.printUsage();
        }
        try {
            String propFile = args[0];
            String outputDir = args[1];
            String className = args[2];
            MsgKeyGenerator.generateMsgKey(propFile, new File(outputDir), className, MsgKeyGenerator.class.getClassLoader());
        }
        catch (RuntimeException e) {
            MsgKeyGenerator.printUsage(e);
        }
        catch (IOException e) {
            MsgKeyGenerator.printUsage(e);
        }
    }

    public static void generateMsgKey(String bundleName, File outputDir, String className, ClassLoader classLoader) throws IOException {
        File javaFile = MsgKeyGenerator.calculateJavaFileName(outputDir, className);
        MsgKeyGenerator.generateMsgKeyToFile(bundleName, javaFile, className, classLoader);
    }

    public static File calculateJavaFileName(File outputDir, String className) {
        String javaFileName = File.separator + MsgKeyGenerator.classNameToFilePath(className) + ".java";
        return new File(outputDir, javaFileName);
    }

    @SuppressWarnings(value={"DM_DEFAULT_ENCODING"})
    public static void generateMsgKeyToFile(String bundleName, File javaFile, String className, ClassLoader classLoader) throws IOException {
        File javaFileDir = javaFile.getParentFile();
        if (!javaFileDir.exists() && !javaFileDir.mkdirs()) {
            throw new RuntimeException("Unable to create package directory " + javaFileDir);
        }
        MsgKeyGenerator generator = null;
        generator = new MsgKeyGenerator(className, bundleName, classLoader);
        FileWriter outputWriter = new FileWriter(javaFile);
        generator.writeCode(outputWriter);
        ((Writer)outputWriter).flush();
        ((Writer)outputWriter).close();
    }

    private static void printUsage() {
        System.err.println("Usage: MsgKeyGenerator <bundle_properties_file> <src_root_dir> <enum_class_name>");
    }

    private static void printUsage(Throwable t) {
        MsgKeyGenerator.printUsage();
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.exit(1);
    }

    static {
        FORMATTER.addHeaderLine("Generated by " + MsgKeyGenerator.class.getName());
    }
}

