/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.protocols.dns.DefaultDNSResolver;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;

public class DNS_PING
extends Discovery {
    private static final String DEFAULT_DNS_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String DEFAULT_DNS_RECORD_TYPE = "A";
    private static final String DNS_QUERY_SUFFIX = ".svc.cluster.local";
    @Property(description="DNS Context Factory")
    protected String dns_context_factory = "com.sun.jndi.dns.DnsContextFactory";
    @Property(description="DNS Address. This property will be assembled with the 'dns://' prefix")
    protected String dns_address = "";
    @Property(description="DNS Record type")
    protected String dns_record_type = "A";
    @Property(description="DNS query for fetching members")
    protected String dns_query;
    protected volatile DNSResolver dns_resolver;
    protected BoundedList<Address> discovered_hosts = new BoundedList();
    private int transportPort;

    @Override
    public void init() throws Exception {
        super.init();
        this.validateProperties();
        this.transportPort = this.getTransport().getBindPort();
        if (this.transportPort <= 0) {
            this.log.warn("Unable to discover transport port. This may prevent members from being discovered.");
        }
        if (this.dns_resolver == null) {
            this.dns_resolver = new DefaultDNSResolver(this.dns_context_factory, this.dns_address);
        }
    }

    protected void validateProperties() {
        if (this.dns_query == null) {
            throw new IllegalArgumentException("dns_query can not be null or empty");
        }
        if (!this.dns_query.endsWith(DNS_QUERY_SUFFIX)) {
            this.dns_query = this.dns_query + DNS_QUERY_SUFFIX;
        }
    }

    @Override
    public void destroy() {
        this.dns_resolver.close();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.view.getMembersRaw()) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, logical_addr));
                    if (physical_addr == null) continue;
                    this.discovered_hosts.addIfAbsent(physical_addr);
                }
                break;
            }
            case 9: {
                Collection<Object> addresses = evt.getArg() instanceof Address ? Collections.singletonList(evt.arg()) : (Collection)evt.arg();
                this.discovered_hosts.removeAll(addresses);
                break;
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr == null) break;
                this.discovered_hosts.addIfAbsent(physical_addr);
            }
        }
        return retval;
    }

    @Override
    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        this.log.debug("Received discovery from: %s, IP: %s", sender.toString(), physical_addr.printIpAddress());
        if (physical_addr != null) {
            this.discovered_hosts.addIfAbsent(sender);
        }
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        PingData data = null;
        PhysicalAddress physical_addr = null;
        if (!this.use_ip_addrs || !initial_discovery) {
            this.log.debug("Performing initial discovery");
            physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
            data = new PingData(this.local_addr, false, NameCache.get(this.local_addr), physical_addr);
            if (members != null && members.size() <= this.max_members_in_discovery_request) {
                data.mbrs(members);
            }
        }
        List<Address> dns_discovery_members = this.dns_resolver.resolveIps(this.dns_query, DNSResolver.DNSRecordType.valueOf(this.dns_record_type));
        this.log.debug("Entries collected from DNS: %s", dns_discovery_members);
        if (dns_discovery_members != null) {
            for (Address address : dns_discovery_members) {
                IpAddress ip;
                if (physical_addr != null && address.equals(physical_addr)) continue;
                Address addressToBeAdded = address;
                if (address instanceof IpAddress && (ip = (IpAddress)address).getPort() == 0) {
                    this.log.debug("Discovered IP Address with port 0 (%s). Replacing with default Transport port: %d", ip.printIpAddress(), this.transportPort);
                    addressToBeAdded = new IpAddress(ip.getIpAddress(), this.transportPort);
                }
                this.discovered_hosts.addIfAbsent(addressToBeAdded);
            }
        }
        this.log.debug("Performing discovery of the following hosts %s", this.discovered_hosts.toString());
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name).initialDiscovery(initial_discovery);
        for (Address addr : this.discovered_hosts) {
            Message msg = new Message(addr).setFlag(Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB).putHeader(this.id, hdr);
            if (data != null) {
                msg.setBuffer(DNS_PING.marshal(data));
            }
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> this.sendDiscoveryRequest(msg), this.sends_can_block);
                continue;
            }
            this.sendDiscoveryRequest(msg);
        }
    }

    protected void sendDiscoveryRequest(Message req) {
        try {
            this.log.debug("%s: sending discovery request to %s", this.local_addr, req.getDest());
            this.down_prot.down(req);
        }
        catch (Throwable t) {
            this.log.debug("sending discovery request to %s failed: %s", req.dest(), t);
        }
    }
}

