/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.ProfilerDataStore;
import com.netapp.oci.profiler.ProfilerService;
import com.netapp.oci.profiler.ProfilerServiceException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProfilerService
implements ProfilerService {
    private static final Logger logger = LoggerFactory.getLogger(BaseProfilerService.class);
    private ProfilerDataStore dataStore;

    @Override
    public void log(Map<String, Object> data) throws ProfilerServiceException {
        try {
            this.dataStore.store(data);
        }
        catch (IOException e) {
            throw new ProfilerServiceException(e);
        }
    }

    @Override
    public void log(String item, Object value) throws ProfilerServiceException {
        try {
            this.dataStore.store(item, value);
        }
        catch (IOException e) {
            throw new ProfilerServiceException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public ProfilerDataStore getDataStore() throws ProfilerServiceException {
        return this.dataStore;
    }

    public void setDataStore(ProfilerDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public void stop() {
        try {
            this.dataStore.close();
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    protected Date getProfilingStartTime() {
        Date current = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(current);
        cal.add(12, 1);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }
}

