/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.Profiler;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;

public class CpuMemoryProfiler
implements Profiler {
    public static final String CPU_USAGE = "Cpu Usage";
    public static final String USED_HEAP_SIZE = "Used Heap Size";
    public static final String CURRENT_HEAP_SIZE = "Current Heap Size";
    public static final String MAX_HEAP_SIZE = "Max Heap Size";
    private long prevUpTime;
    private long prevProcessCpuTime;
    private int nCPUs;
    private OperatingSystemMXBean osbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private RuntimeMXBean runbean = ManagementFactory.getRuntimeMXBean();

    public CpuMemoryProfiler() {
        this.nCPUs = this.osbean.getAvailableProcessors();
        this.prevUpTime = this.runbean.getUptime();
        this.prevProcessCpuTime = this.osbean.getProcessCpuTime();
    }

    @Override
    public Map<String, Object> sample() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long usedHeapSize = totalMemory - freeMemory;
        HashMap<String, Object> profileData = new HashMap<String, Object>();
        profileData.put(CPU_USAGE, this.getCpuUsage());
        profileData.put(USED_HEAP_SIZE, usedHeapSize);
        profileData.put(CURRENT_HEAP_SIZE, totalMemory);
        profileData.put(MAX_HEAP_SIZE, runtime.maxMemory());
        return profileData;
    }

    public double getCpuUsage() {
        double cpuUsage;
        long upTime = this.runbean.getUptime();
        long processCpuTime = this.osbean.getProcessCpuTime();
        if (this.prevUpTime > 0L && upTime > this.prevUpTime) {
            long elapsedCpu = processCpuTime - this.prevProcessCpuTime;
            long elapsedTime = upTime - this.prevUpTime;
            cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)this.nCPUs));
        } else {
            cpuUsage = 0.001;
        }
        this.prevUpTime = upTime;
        this.prevProcessCpuTime = processCpuTime;
        return cpuUsage;
    }
}

