/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.ProfilerDataStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CsvFileDataStore
implements ProfilerDataStore {
    private Map<String, Integer> headerIndexMap;
    private int noOfHeaders;
    private BufferedWriter writer;

    public CsvFileDataStore(File outputFile, String[] headers) throws IOException {
        ArrayList<String> headersList = new ArrayList<String>(headers.length + 1);
        headersList.add("Time");
        headersList.addAll(Arrays.asList(headers));
        this.headerIndexMap = new HashMap<String, Integer>();
        int index = 0;
        for (String header : headersList) {
            this.headerIndexMap.put(header, index++);
        }
        this.noOfHeaders = index;
        this.writer = new BufferedWriter(new FileWriter(outputFile));
        this.writeRow(headersList.toArray());
    }

    @Override
    public void store(Map<String, Object> events) throws IOException {
        if (!events.containsKey("Time")) {
            events.put("Time", System.currentTimeMillis());
        }
        Object[] orderedValues = this.orderByColumns(events);
        this.writeRow(orderedValues);
    }

    private synchronized void writeRow(Object[] orderedValues) throws IOException {
        this.writer.write(this.toCsvString(orderedValues));
        this.writer.newLine();
        this.writer.flush();
    }

    private String toCsvString(Object[] values) {
        assert (values.length > 0);
        StringBuilder str = new StringBuilder();
        for (Object value : values) {
            str.append(value == null ? "" : value);
            str.append(',');
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    private Object[] orderByColumns(Map<String, Object> data) {
        Object[] orderedValues = new Object[this.noOfHeaders];
        for (Map.Entry<String, Object> itemValuePair : data.entrySet()) {
            int index = this.headerIndexMap.get(itemValuePair.getKey());
            orderedValues[index] = itemValuePair.getValue();
        }
        return orderedValues;
    }

    @Override
    public void store(String event, Object value) throws IOException {
        Object[] orderedValues = new Object[this.noOfHeaders];
        orderedValues[0] = System.currentTimeMillis();
        int index = this.headerIndexMap.get(event);
        orderedValues[index] = value;
        this.writeRow(orderedValues);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

