/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.Profiler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DirSizeProfiler
implements Profiler {
    private File dir;
    private String profileItemName;

    public DirSizeProfiler(String profileItemName, File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this.dir = dir;
        this.profileItemName = profileItemName;
    }

    @Override
    public Map<String, Object> sample() {
        HashMap<String, Object> profileData = new HashMap<String, Object>();
        profileData.put(this.profileItemName, this.folderSize(this.dir));
        return profileData;
    }

    private long folderSize(File directory) {
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += this.folderSize(file);
        }
        return length;
    }
}

