/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.Profiler;
import com.onaro.commons.exec.Exec;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtProcCpuMemoryUsageProfiler
implements Profiler {
    private static final Logger logger = LoggerFactory.getLogger(ExtProcCpuMemoryUsageProfiler.class);
    private static final double[] ERROR_SAMPLE = new double[]{-1.0, -1.0};
    private String processName;
    private boolean disabled;
    private String[] profilerDataName;

    public ExtProcCpuMemoryUsageProfiler(String[] profilerDataName, String processName) {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        if (!isWindows) {
            logger.warn("External Process CPU Usage Profiler supports only Windows OS for now.");
            this.disabled = true;
        }
        this.processName = processName;
        this.profilerDataName = profilerDataName;
    }

    @Override
    public Map<String, Object> sample() {
        double[] cpuUsage = !this.disabled ? this.getWindowsCpuUsage() : ERROR_SAMPLE;
        HashMap<String, Object> profileData = new HashMap<String, Object>();
        profileData.put(this.profilerDataName[0], cpuUsage[0]);
        profileData.put(this.profilerDataName[1], cpuUsage[1]);
        return profileData;
    }

    private double[] getWindowsCpuUsage() {
        Exec exec = new Exec("typeperf -sc 1 \"\\Process(" + this.processName + ")\\% processor time\"  \"\\Process(" + this.processName + ")\\working set\"");
        exec.run(5000L);
        if (exec.getExitCode() == 0) {
            String output = exec.getOutput();
            try {
                String[] tempStrArray = output.split(",");
                String cpuUsageStr = tempStrArray[3];
                String memUsageStr = tempStrArray[4].split("\\s")[0];
                double cpuUsage = Double.parseDouble(cpuUsageStr.replace("\"", ""));
                double memUsage = Double.parseDouble(memUsageStr.replace("\"", ""));
                return new double[]{cpuUsage, memUsage};
            }
            catch (NumberFormatException e) {
                logger.error("", e);
                this.disabled = true;
            }
        } else {
            logger.error(exec.getError());
            logger.error("Exit Code: " + exec.getExitCode());
            this.disabled = true;
        }
        return ERROR_SAMPLE;
    }

    public static void main(String[] args) {
        Map<String, Object> sample = new ExtProcCpuMemoryUsageProfiler(new String[]{"MySQL CPU Usage", "MySQL Mem Usage"}, "mysqld").sample();
        System.out.println(sample);
    }
}

