/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.Profiler;
import com.netapp.oci.profiler.ProfilerService;
import java.util.HashMap;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerTimerTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(ProfilerTimerTask.class);
    private Profiler[] profilers;
    private ProfilerService profilerService;

    public ProfilerTimerTask(ProfilerService profilerService, Profiler[] profilers) {
        this.profilerService = profilerService;
        this.profilers = profilers;
    }

    @Override
    public void run() {
        try {
            HashMap<String, Object> profileData = new HashMap<String, Object>();
            profileData.put("Time", System.currentTimeMillis());
            for (Profiler profiler : this.profilers) {
                profileData.putAll(profiler.sample());
            }
            this.profilerService.log(profileData);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}

