/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ProfilerDataProcessor {
    private BufferedReader br;
    private BufferedWriter bwMem;
    private BufferedWriter bwOrig;
    private Map<String, Long> originatorToStartTimeMap;

    public ProfilerDataProcessor(File profilerCsvFile) throws Exception {
        this.br = new BufferedReader(new FileReader(profilerCsvFile));
        this.bwMem = new BufferedWriter(new FileWriter(profilerCsvFile.getParent() + File.separator + "Mem_" + profilerCsvFile.getName()));
        this.bwOrig = new BufferedWriter(new FileWriter(profilerCsvFile.getParent() + File.separator + "OrigUpdate_" + profilerCsvFile.getName()));
        this.originatorToStartTimeMap = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        try {
            this.bwOrig.write(this.constructNewRow("OriginId", "StartTime", "EndTime", "Duration"));
            this.bwOrig.newLine();
            String line = this.br.readLine();
            String[] splits = line.split(",");
            int noOfHeaders = splits.length;
            int originStartIndex = noOfHeaders - 2;
            int originEndIndex = noOfHeaders - 1;
            while (line != null && line.trim().length() != 0) {
                splits = line.split(",");
                if (!splits[1].equals("")) {
                    this.bwMem.write(this.constructNewRow(Arrays.copyOf(splits, originStartIndex)));
                    this.bwMem.newLine();
                } else {
                    long timeInMillis = Long.parseLong(splits[0]);
                    String originId = splits[originStartIndex].equals("") ? splits[originEndIndex] : splits[originStartIndex];
                    if (this.originatorToStartTimeMap.containsKey(originId)) {
                        long startTime = this.originatorToStartTimeMap.get(originId);
                        this.bwOrig.write(this.constructNewRow(String.valueOf(originId), String.valueOf(startTime), String.valueOf(timeInMillis), String.valueOf(timeInMillis - startTime)));
                        this.bwOrig.newLine();
                        this.originatorToStartTimeMap.remove(originId);
                    } else {
                        this.originatorToStartTimeMap.put(originId, timeInMillis);
                    }
                }
                line = this.br.readLine();
            }
        }
        finally {
            this.br.close();
            this.bwMem.close();
            this.bwOrig.close();
        }
    }

    private String constructNewRow(String ... str) {
        StringBuilder newLine = new StringBuilder(str[0]);
        for (int i = 1; i < str.length; ++i) {
            newLine.append(',');
            newLine.append(str[i]);
        }
        return newLine.toString();
    }

    public static void main(String[] args) throws Exception {
        new ProfilerDataProcessor(new File(args[0])).process();
    }
}

