/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfo
extends FieldInfo {
    private XSList xsList = (XSList)this.getSchemaType();
    private String contentName = null;
    private XSType contentType = null;
    private FieldInfo content = null;
    private String elementName;

    public CollectionInfo(XSType xSType, String string, String string2) {
        super(new XSList(xSType), string);
        this.contentType = xSType;
        this.contentName = "v" + JavaNaming.toJavaClassName(string2);
        this.elementName = string2;
        this.content = new FieldInfo(xSType, this.contentName);
    }

    public void generateInitializerCode(JSourceCode jSourceCode) {
        jSourceCode.add(this.getName());
        jSourceCode.append(" = new Vector();");
    }

    public String getReadMethodName() {
        StringBuffer stringBuffer = new StringBuffer("get");
        stringBuffer.append(JavaNaming.toJavaClassName(this.getElementName()));
        return stringBuffer.toString();
    }

    public String getWriteMethodName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("add");
        stringBuffer.append(JavaNaming.toJavaClassName(this.getElementName()));
        return stringBuffer.toString();
    }

    public void createAccessMethods(JClass jClass) {
        JMethod jMethod = null;
        JParameter jParameter = new JParameter(this.getContentType().getJType(), this.getContentName());
        Object var4_4 = null;
        String string = JavaNaming.toJavaClassName(this.getElementName());
        jMethod = new JMethod(null, "add" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(jParameter);
        this.createAddMethod(jMethod);
        jMethod = new JMethod(null, "add" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        jMethod.addParameter(jParameter);
        this.createAddInsertMethod(jMethod);
        JType jType = this.getContentType().getJType();
        jMethod = new JMethod(jType, "get" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        this.createGetByIndexMethod(jMethod);
        jType = jType.createArray();
        jMethod = new JMethod(jType, "get" + string);
        jClass.addMethod(jMethod);
        this.createGetMethod(jMethod);
        jMethod = new JMethod(null, "set" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        jMethod.addParameter(jParameter);
        this.createSetByIndexMethod(jMethod);
        JType jType2 = jParameter.getType().createArray();
        String string2 = JavaNaming.toJavaMemberName(string);
        JParameter jParameter2 = new JParameter(jType2, string2 + "Array");
        jMethod = new JMethod(null, "set" + string);
        jMethod.addParameter(jParameter2);
        jClass.addMethod(jMethod);
        this.createSetArrayMethod(jMethod);
        jMethod = new JMethod(JType.Int, "get" + string + "Count");
        jClass.addMethod(jMethod);
        this.createGetCountMethod(jMethod);
        jMethod = new JMethod(SGTypes.Enumeration, "enumerate" + string);
        jClass.addMethod(jMethod);
        this.createEnumerateMethod(jMethod);
        jType = this.getContentType().getJType();
        jMethod = new JMethod(jType, "remove" + string);
        jClass.addMethod(jMethod);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        this.createRemoveByIndexMethod(jMethod);
        jMethod = new JMethod(null, "removeAll" + string);
        jClass.addMethod(jMethod);
        this.createRemoveAllMethod(jMethod);
    }

    public JMethod getReadMethod() {
        String string = this.getReadMethodName();
        JType jType = this.getContentType().getJType();
        JMethod jMethod = new JMethod(jType, string);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return this.");
        jSourceCode.append(this.getName());
        jSourceCode.append(";");
        return jMethod;
    }

    public XSList getXSList() {
        return this.xsList;
    }

    public String getContentName() {
        return this.contentName;
    }

    public XSType getContentType() {
        return this.contentType;
    }

    public FieldInfo getContent() {
        return this.content;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isMultivalued() {
        return true;
    }

    public void createAddMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".addElement(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createAddInsertMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".insertElementAt(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(", index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createGetMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("int size = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size();");
        String string = this.getName() + ".elementAt(index)";
        JType jType2 = jType.getComponentType();
        jSourceCode.add(jType2.toString());
        jSourceCode.append("[] mArray = new ");
        jSourceCode.append(jType2.toString());
        jSourceCode.append("[size]");
        if (jType2.isArray()) {
            jSourceCode.append("[]");
        }
        jSourceCode.append(";");
        jSourceCode.add("for (int index = 0; index < size; index++) {");
        jSourceCode.indent();
        jSourceCode.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getLocalName());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return mArray;");
    }

    public void createGetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("");
        jSourceCode.add("return ");
        String string = this.getName() + ".elementAt(index)";
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.toString());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
    }

    public void createSetArrayMethod(JMethod jMethod) {
        String string;
        JSourceCode jSourceCode = jMethod.getSourceCode();
        String string2 = jMethod.getParameter(0).getName();
        if (string2.equals(string = "i")) {
            string = "j";
        }
        jSourceCode.add("//-- copy array");
        jSourceCode.add(this.getName());
        jSourceCode.append(".removeAllElements();");
        jSourceCode.add("for (int ");
        jSourceCode.append(string);
        jSourceCode.append(" = 0; ");
        jSourceCode.append(string);
        jSourceCode.append(" < ");
        jSourceCode.append(string2);
        jSourceCode.append(".length; ");
        jSourceCode.append(string);
        jSourceCode.append("++) {");
        jSourceCode.indent();
        jSourceCode.add(this.getName());
        jSourceCode.append(".addElement(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(string2 + '[' + string + ']'));
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createSetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append("index < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".setElementAt(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(", index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    protected void createBoundPropertyCode(JSourceCode jSourceCode) {
        jSourceCode.add("notifyPropertyChangeListeners(\"");
        jSourceCode.append(this.getName());
        jSourceCode.append("\", null, ");
        jSourceCode.append(this.getName());
        jSourceCode.append(");");
    }

    public void createGetCountMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size();");
    }

    public void createEnumerateMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".elements();");
    }

    public void createRemoveByObjectMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("boolean removed = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".removeElement(");
        jSourceCode.append(this.getContentName());
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
        jSourceCode.add("return removed;");
    }

    public void createRemoveByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("java.lang.Object obj = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".elementAt(index);");
        jSourceCode.add(this.getName());
        jSourceCode.append(".removeElementAt(index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
        jSourceCode.add("return ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getName());
            jSourceCode.append(") obj;");
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode("obj"));
            jSourceCode.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(this.getName());
        jSourceCode.append(".removeAllElements();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }
}

