/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.types.XSListODMG30;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfoODMG30
extends CollectionInfo {
    public CollectionInfoODMG30(XSType xSType, String string, String string2) {
        super(xSType, string, string2);
        this.setSchemaType(new XSListODMG30(xSType));
    }

    public void generateInitializerCode(JSourceCode jSourceCode) {
        jSourceCode.add(this.getName());
        jSourceCode.append(" = ODMG.getImplementation().newDArray();");
    }

    public void createAddMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
    }

    public void createAddInsertMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(index, ");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createGetMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("int size = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size();");
        String string = this.getName() + ".get(index)";
        JType jType2 = jType.getComponentType();
        jSourceCode.add(jType2.toString());
        jSourceCode.append("[] mArray = new ");
        jSourceCode.append(jType2.toString());
        jSourceCode.append("[size]");
        if (jType2.isArray()) {
            jSourceCode.append("[]");
        }
        jSourceCode.append(";");
        jSourceCode.add("for (int index = 0; index < size; index++) {");
        jSourceCode.indent();
        jSourceCode.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getLocalName());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return mArray;");
    }

    public void createGetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("");
        jSourceCode.add("return ");
        String string = this.getName() + ".get(index)";
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.toString());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
    }

    public void createSetArrayMethod(JMethod jMethod) {
        String string;
        JSourceCode jSourceCode = jMethod.getSourceCode();
        String string2 = jMethod.getParameter(0).getName();
        if (string2.equals(string = "i")) {
            string = "j";
        }
        jSourceCode.add("//-- copy array");
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
        jSourceCode.add("for (int ");
        jSourceCode.append(string);
        jSourceCode.append(" = 0; ");
        jSourceCode.append(string);
        jSourceCode.append(" < ");
        jSourceCode.append(string2);
        jSourceCode.append(".length; ");
        jSourceCode.append(string);
        jSourceCode.append("++) {");
        jSourceCode.indent();
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(string2 + '[' + string + ']'));
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createSetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        int n = this.getXSList().getMaximumSize();
        if (n != 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".set(");
        jSourceCode.append("index, ");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
    }

    public void createGetCountMethod(JMethod jMethod) {
        super.createGetCountMethod(jMethod);
    }

    public void createEnumerateMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("java.util.Vector v = new java.util.Vector();");
        jSourceCode.add("java.util.Iterator i = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".iterator();");
        jSourceCode.add("while(i.hasNext()) v.add(i.next());");
        jSourceCode.add("return v.elements();");
    }

    public void createRemoveByObjectMethod(JMethod jMethod) {
        super.createRemoveByObjectMethod(jMethod);
    }

    public void createRemoveByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("java.lang.Object obj = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".get(index);");
        jSourceCode.add(this.getName());
        jSourceCode.append(".remove(index);");
        jSourceCode.add("return ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getName());
            jSourceCode.append(") obj;");
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode("obj"));
            jSourceCode.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
    }
}

