/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.TokenTypes;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.QueryExpression;

public class ParseTreeWalker
implements TokenTypes {
    private LockEngine _dbEngine;
    private ParseTreeNode _parseTree;
    private String _projectionName;
    private String _projectionAlias;
    private int _projectionType;
    private String _fromClassName;
    private String _fromClassAlias;
    private ClassLoader _classLoader;
    private Class _objClass;
    private QueryExpression _queryExpr;
    private int _SQLParamIndex;
    private Hashtable _paramInfo;
    private Hashtable _fieldInfo;
    private Hashtable _pathInfo;
    private Hashtable _allPaths;
    private SQLEngine _engine;
    private JDOClassDescriptor _clsDesc;
    public static final int AGGREGATE = 1;
    public static final int FUNCTION = 2;
    public static final int PARENT_OBJECT = 3;
    public static final int DEPENDANT_OBJECT = 4;
    public static final int DEPENDANT_OBJECT_VALUE = 5;
    public static final int DEPENDANT_VALUE = 6;
    public static final int MAX_TABLE_LENGTH = 30;

    public ParseTreeWalker(LockEngine lockEngine, ParseTreeNode parseTreeNode, ClassLoader classLoader) throws QueryException {
        this._dbEngine = lockEngine;
        this._parseTree = parseTreeNode;
        this._classLoader = classLoader;
        this._SQLParamIndex = 1;
        this._paramInfo = new Hashtable();
        this._fieldInfo = new Hashtable();
        this._pathInfo = new Hashtable();
        this._allPaths = new Hashtable();
        if (!this._parseTree.isRoot()) {
            throw new QueryException("ParseTreeWalker must be created with the root node of the parse tree.");
        }
        this.checkErrors();
        this.createQueryExpression();
    }

    public Class getObjClass() {
        return this._objClass;
    }

    public int getProjectionType() {
        return this._projectionType;
    }

    public QueryExpression getQueryExpression() {
        return this._queryExpr;
    }

    public Hashtable getParamInfo() {
        return this._paramInfo;
    }

    public JDOClassDescriptor getClassDescriptor() {
        return this._clsDesc;
    }

    public Vector getPathInfo() {
        switch (this._projectionType) {
            case 4: 
            case 5: {
                ParseTreeNode parseTreeNode = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
                if (parseTreeNode.getToken().getTokenType() == 3) {
                    parseTreeNode = parseTreeNode.getChild(0);
                }
                return (Vector)this._pathInfo.get(parseTreeNode);
            }
        }
        return null;
    }

    private void checkErrors() throws QueryException {
        Enumeration enumeration = this._parseTree.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode = (ParseTreeNode)enumeration.nextElement();
            if (parseTreeNode.getToken().getTokenType() != 5) continue;
            this.checkFromPart(parseTreeNode.getChild(0));
            break;
        }
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this.checkSelectPart(this._parseTree.getChild(1));
        } else {
            this.checkSelectPart(this._parseTree.getChild(0));
        }
        int n = 2;
        while (n <= this._parseTree.getChildCount() - 1) {
            int n2 = this._parseTree.getChild(n).getToken().getTokenType();
            switch (n2) {
                case 7: {
                    this.checkWhereClause(this._parseTree.getChild(n));
                    break;
                }
                case 46: {
                    this.checkOrderClause(this._parseTree.getChild(n));
                    break;
                }
                case 55: {
                    this.checkLimitClause(this._parseTree.getChild(n));
                }
            }
            ++n;
        }
    }

    private void checkFromPart(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() == 3) {
            ParseTreeNode parseTreeNode2 = parseTreeNode.getChild(0);
            if (parseTreeNode2.getToken().getTokenType() == 30) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = parseTreeNode2.children();
                while (enumeration.hasMoreElements()) {
                    ParseTreeNode parseTreeNode3 = (ParseTreeNode)enumeration.nextElement();
                    stringBuffer.append(parseTreeNode3.getToken().getTokenValue()).append(".");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                this._fromClassName = stringBuffer.toString();
            } else {
                this._fromClassName = parseTreeNode2.getToken().getTokenValue();
            }
            this._fromClassAlias = parseTreeNode.getChild(1).getToken().getTokenValue();
        } else {
            if (parseTreeNode.getToken().getTokenType() == 30) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    ParseTreeNode parseTreeNode4 = (ParseTreeNode)enumeration.nextElement();
                    stringBuffer.append(parseTreeNode4.getToken().getTokenValue()).append(".");
                }
                this._fromClassName = stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
            } else {
                this._fromClassName = parseTreeNode.getToken().getTokenValue();
            }
            this._fromClassAlias = this._fromClassName;
        }
        try {
            this._objClass = this._classLoader == null ? Class.forName(this._fromClassName) : this._classLoader.loadClass(this._fromClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QueryException("Could not find class " + this._fromClassName);
        }
        this._engine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
        if (this._engine == null) {
            throw new QueryException("Could not find mapping for class " + this._fromClassName);
        }
        this._clsDesc = this._engine.getDescriptor();
        if (this._clsDesc == null) {
            throw new QueryException("Could not get a descriptor for class " + this._fromClassName);
        }
    }

    private void checkSelectPart(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() == 3) {
            this.checkProjection(parseTreeNode.getChild(0), true, false);
            this._projectionAlias = parseTreeNode.getChild(1).getToken().getTokenValue();
        } else {
            this.checkProjection(parseTreeNode, true, false);
            this._projectionAlias = "";
        }
    }

    private JDOFieldDescriptor getFieldDesc(String string, JDOClassDescriptor jDOClassDescriptor) {
        JDOClassDescriptor jDOClassDescriptor2 = jDOClassDescriptor;
        while (jDOClassDescriptor2 != null) {
            JDOFieldDescriptor jDOFieldDescriptor = jDOClassDescriptor2.getField(string);
            if (jDOFieldDescriptor != null) {
                return jDOFieldDescriptor;
            }
            jDOClassDescriptor2 = (JDOClassDescriptor)jDOClassDescriptor2.getExtends();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JDOFieldDescriptor checkProjection(ParseTreeNode parseTreeNode, boolean bl, boolean bl2) throws QueryException {
        FieldDescriptorImpl fieldDescriptorImpl = null;
        if (parseTreeNode.getChildCount() == 0) {
            if (bl) {
                this._projectionType = 3;
                this._projectionName = parseTreeNode.getToken().getTokenValue();
                if (this._projectionName.equals(this._fromClassAlias)) return fieldDescriptorImpl;
                throw new QueryException("Object name not the same in SELECT and FROM - select: " + this._projectionName + ", from: " + this._fromClassAlias);
            }
            if (!bl2) return null;
            throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
        }
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 2: {
                this._projectionType = 2;
                Enumeration enumeration = parseTreeNode.getChild(0).children();
                while (enumeration.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)enumeration.nextElement(), false, true);
                }
                return fieldDescriptorImpl;
            }
            case 30: {
                Enumeration enumeration = parseTreeNode.children();
                ParseTreeNode parseTreeNode2 = null;
                String string = null;
                StringBuffer stringBuffer = new StringBuffer();
                Vector<String> vector = new Vector<String>();
                if (enumeration.hasMoreElements()) {
                    parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
                    string = parseTreeNode2.getToken().getTokenValue();
                    if (!(string.equals(this._projectionName) || string.equals(this._projectionAlias) || string.equals(this._fromClassName) || string.equals(this._fromClassAlias))) {
                        enumeration = parseTreeNode.children();
                        string = this._fromClassAlias;
                    }
                    stringBuffer.append(string);
                    vector.addElement(string);
                }
                JDOClassDescriptor jDOClassDescriptor = this._clsDesc;
                FieldDescriptorImpl fieldDescriptorImpl2 = null;
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    fieldDescriptorImpl2 = null;
                    string = null;
                    while (fieldDescriptorImpl2 == null && enumeration.hasMoreElements()) {
                        parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
                        String string2 = parseTreeNode2.getToken().getTokenValue();
                        string = string == null ? string2 : string + "." + string2;
                        fieldDescriptorImpl2 = this.getFieldDesc(string, jDOClassDescriptor);
                    }
                    if (fieldDescriptorImpl2 == null) {
                        throw new QueryException("An unknown field was requested: " + string + " (" + jDOClassDescriptor + ")");
                    }
                    stringBuffer.append(".").append(string);
                    vector.addElement(string);
                    jDOClassDescriptor = (JDOClassDescriptor)fieldDescriptorImpl2.getClassDescriptor();
                    if (jDOClassDescriptor == null && enumeration.hasMoreElements()) {
                        throw new QueryException("An non-reference field was requested: " + string + " (" + jDOClassDescriptor + ")");
                    }
                    ++n2;
                }
                fieldDescriptorImpl = fieldDescriptorImpl2;
                this._pathInfo.put(parseTreeNode, vector);
                this._fieldInfo.put(parseTreeNode, fieldDescriptorImpl2);
                Class clazz = fieldDescriptorImpl2.getFieldType();
                boolean bl3 = Types.isSimpleType(clazz);
                if (bl) {
                    this._projectionName = stringBuffer.toString();
                    if (bl3) {
                        if (n2 > 1 || fieldDescriptorImpl.getContainingClassDescriptor() != this._clsDesc) {
                            this._projectionType = 5;
                            return fieldDescriptorImpl;
                        }
                        this._projectionType = 6;
                        return fieldDescriptorImpl;
                    }
                    this._projectionType = 4;
                    return fieldDescriptorImpl;
                }
                if (bl3 || !bl2) return fieldDescriptorImpl;
                throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
            }
            case 50: {
                this._projectionType = 1;
                if (parseTreeNode.getChild(0).getToken().getTokenType() == 20) return fieldDescriptorImpl;
                this.checkProjection(parseTreeNode.getChild(0), false, false);
                return fieldDescriptorImpl;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this._projectionType = 1;
                this.checkProjection(parseTreeNode.getChild(0), false, true);
                return fieldDescriptorImpl;
            }
            default: {
                this._projectionType = 2;
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)enumeration.nextElement(), false, false);
                }
                break block0;
            }
        }
        return fieldDescriptorImpl;
    }

    private void checkWhereClause(ParseTreeNode parseTreeNode) throws QueryException {
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 30: {
                this.checkProjection(parseTreeNode, false, false);
                break;
            }
            case 2: {
                Enumeration enumeration = parseTreeNode.children();
                if (enumeration.hasMoreElements()) {
                    if (parseTreeNode.getChild(0).getToken().getTokenType() != 25) break;
                    while (enumeration.hasMoreElements()) {
                        this.checkWhereClause((ParseTreeNode)enumeration.nextElement());
                    }
                    break;
                }
                this.checkField(parseTreeNode);
                break;
            }
            case 27: {
                this.checkParameter(parseTreeNode);
                break;
            }
            case 6: {
                this.checkField(parseTreeNode.getChild(0));
                this.checkInClauseRightSide(parseTreeNode.getChild(1));
            }
            default: {
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkWhereClause((ParseTreeNode)enumeration.nextElement());
                }
                break block0;
            }
        }
    }

    private void checkLimitClause(ParseTreeNode parseTreeNode) throws QueryException {
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 27: {
                this.checkParameter(parseTreeNode);
                break;
            }
            default: {
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    this.checkLimitClause((ParseTreeNode)enumeration.nextElement());
                }
                break block0;
            }
        }
    }

    private JDOFieldDescriptor checkField(ParseTreeNode parseTreeNode) throws QueryException {
        JDOFieldDescriptor jDOFieldDescriptor = (JDOFieldDescriptor)this._fieldInfo.get(parseTreeNode);
        if (jDOFieldDescriptor != null) {
            return jDOFieldDescriptor;
        }
        if (parseTreeNode.getToken().getTokenType() == 30) {
            jDOFieldDescriptor = this.checkProjection(parseTreeNode, false, false);
        } else {
            jDOFieldDescriptor = this.getFieldDesc(parseTreeNode.getToken().getTokenValue(), this._clsDesc);
            if (jDOFieldDescriptor != null) {
                this._fieldInfo.put(parseTreeNode, jDOFieldDescriptor);
            }
        }
        if (jDOFieldDescriptor == null) {
            throw new QueryException("The field " + parseTreeNode.getToken().getTokenValue() + " was not found.");
        }
        return jDOFieldDescriptor;
    }

    private void checkParameter(ParseTreeNode parseTreeNode) throws QueryException {
        Integer n;
        String string = "";
        if (parseTreeNode.getChildCount() == 1) {
            n = Integer.decode(parseTreeNode.getChild(0).getToken().getTokenValue());
        } else {
            n = Integer.decode(parseTreeNode.getChild(1).getToken().getTokenValue());
            string = parseTreeNode.getChild(0).getToken().getTokenValue();
        }
        String string2 = "";
        JDOFieldDescriptor jDOFieldDescriptor = null;
        int n2 = parseTreeNode.getParent().getToken().getTokenType();
        switch (n2) {
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 55: {
                string2 = "java.lang.Number";
                break;
            }
            case 12: 
            case 19: {
                string2 = "java.lang.String";
                break;
            }
            case 8: 
            case 9: 
            case 24: {
                string2 = "java.lang.Boolean";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 40: {
                string2 = this.getTypeForComparison(parseTreeNode.getParent());
                jDOFieldDescriptor = this.getJDOFieldDescriptor(parseTreeNode.getParent());
            }
        }
        ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n);
        if (paramInfo == null) {
            paramInfo = new ParamInfo(string, string2, jDOFieldDescriptor);
            this._paramInfo.put(n, paramInfo);
        } else {
            paramInfo.check(string, string2);
        }
    }

    private String getTypeForComparison(ParseTreeNode parseTreeNode) throws QueryException {
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            if (n != 30 && n != 2) continue;
            JDOFieldDescriptor jDOFieldDescriptor = this.checkField(parseTreeNode2);
            return jDOFieldDescriptor.getFieldType().getName();
        }
        throw new QueryException("Could not get type for comparison.");
    }

    private JDOFieldDescriptor getJDOFieldDescriptor(ParseTreeNode parseTreeNode) throws QueryException {
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            if (n != 30 && n != 2) continue;
            return this.checkField(parseTreeNode2);
        }
        return null;
    }

    private void checkInClauseRightSide(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() != 44) {
            throw new QueryException("The right side of the IN operator must be a LIST.");
        }
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            switch (((ParseTreeNode)enumeration.nextElement()).getToken().getTokenType()) {
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    throw new QueryException("The LIST can only contain literals and Keywords nil and undefined.");
                }
            }
        }
    }

    private void checkOrderClause(ParseTreeNode parseTreeNode) throws QueryException {
        if (parseTreeNode.getToken().getTokenType() != 46) {
            throw new QueryException("checkOrderClause was called on a subtree which is not an order clause.");
        }
        ParseTreeNode parseTreeNode2 = null;
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode3 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode3.getToken().getTokenType();
            switch (n) {
                case 48: 
                case 49: {
                    parseTreeNode3 = parseTreeNode3.getChild(0);
                    n = parseTreeNode3.getToken().getTokenType();
                }
            }
            switch (n) {
                case 30: {
                    this.checkProjection(parseTreeNode3, false, false);
                    break;
                }
                case 2: {
                    if (parseTreeNode3.children().hasMoreElements()) {
                        if (parseTreeNode3.getChild(0).getToken().getTokenType() != 25) break;
                        Enumeration enumeration2 = parseTreeNode3.getChild(0).children();
                        while (enumeration2.hasMoreElements()) {
                            ParseTreeNode parseTreeNode4 = (ParseTreeNode)enumeration2.nextElement();
                            this.checkWhereClause(parseTreeNode4);
                        }
                        break;
                    }
                    this.checkField(parseTreeNode3);
                    break;
                }
                case 25: {
                    if (parseTreeNode2 != null && parseTreeNode2.getToken().getTokenType() == 2) break;
                    throw new QueryException("Illegal use of left parenthesis in ORDER BY clause.");
                }
                default: {
                    throw new QueryException("Only identifiers, path expressions, and the keywords ASC and DESC are allowed in the ORDER BY clause.");
                }
            }
            parseTreeNode2 = parseTreeNode3;
        }
    }

    private void createQueryExpression() {
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                this._queryExpr = this._engine.getFinder();
                break;
            }
            default: {
                this._queryExpr = this._engine.getQueryExpression();
                this.addSelectFromJoins();
            }
        }
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this._queryExpr.setDistinct(true);
        }
        Enumeration enumeration = this._parseTree.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode.getToken().getTokenType();
            switch (n) {
                case 7: {
                    this.addWhereClause(parseTreeNode);
                    break;
                }
                case 46: {
                    this._queryExpr.addOrderClause(this.getOrderClause(parseTreeNode));
                    break;
                }
                case 55: {
                    this.addLimitClause(parseTreeNode);
                }
            }
        }
    }

    private void addSelectFromJoins() {
        ParseTreeNode parseTreeNode = null;
        parseTreeNode = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
        this._queryExpr.addTable(this._clsDesc.getTableName());
        this._queryExpr.addSelect(this.getSQLExpr(parseTreeNode));
    }

    public String buildTableAlias(String string, Vector vector, int n) {
        String string2 = string;
        if (vector != null && vector.size() > 2) {
            int n2;
            Vector vector2 = new Vector(vector.subList(0, n + 1));
            Integer n3 = (Integer)this._allPaths.get(vector2);
            if (n3 == null) {
                n2 = this._allPaths.size();
                this._allPaths.put(vector2, new Integer(n2));
            } else {
                n2 = n3;
            }
            String string3 = String.valueOf(n2);
            if (string2.length() + string3.length() + 1 > 30) {
                string2 = string2.substring(30 - (string3.length() + 1));
            }
            string2 = string2.replace('.', '_') + "_" + n2;
        }
        return string2;
    }

    private void addJoinsForPathExpression(Vector vector) {
        if (vector == null) {
            throw new IllegalStateException("path = null !");
        }
        JDOClassDescriptor jDOClassDescriptor = this._clsDesc;
        int n = 1;
        while (n < vector.size() - 1) {
            FieldDescriptorImpl fieldDescriptorImpl = null;
            while (fieldDescriptorImpl == null) {
                fieldDescriptorImpl = jDOClassDescriptor.getField((String)vector.elementAt(n));
                if (fieldDescriptorImpl != null) continue;
                jDOClassDescriptor = (JDOClassDescriptor)jDOClassDescriptor.getExtends();
            }
            JDOClassDescriptor jDOClassDescriptor2 = (JDOClassDescriptor)fieldDescriptorImpl.getClassDescriptor();
            if (jDOClassDescriptor2 != null) {
                Object object;
                JDOFieldDescriptor jDOFieldDescriptor;
                if (((JDOFieldDescriptor)fieldDescriptorImpl).getManyKey() == null) {
                    jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor2.getIdentity();
                    object = jDOClassDescriptor.getTableName();
                    if (n > 1) {
                        object = this.buildTableAlias((String)object, vector, n - 1);
                    }
                    this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), ((JDOFieldDescriptor)fieldDescriptorImpl).getSQLName(), (String)object, jDOClassDescriptor2.getTableName(), jDOFieldDescriptor.getSQLName(), this.buildTableAlias(jDOClassDescriptor2.getTableName(), vector, n));
                } else if (((JDOFieldDescriptor)fieldDescriptorImpl).getManyTable() == null) {
                    jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor.getIdentity();
                    object = jDOClassDescriptor.getTableName();
                    if (n > 1) {
                        object = this.buildTableAlias((String)object, vector, n - 1);
                    }
                    this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), jDOFieldDescriptor.getSQLName(), (String)object, jDOClassDescriptor2.getTableName(), ((JDOFieldDescriptor)fieldDescriptorImpl).getManyKey(), this.buildTableAlias(jDOClassDescriptor2.getTableName(), vector, n));
                } else {
                    jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor.getIdentity();
                    object = (JDOFieldDescriptor)jDOClassDescriptor2.getIdentity();
                    String string = ((JDOFieldDescriptor)fieldDescriptorImpl).getManyTable();
                    String string2 = jDOClassDescriptor.getTableName();
                    if (n > 1) {
                        string = this.buildTableAlias(string, vector, n - 1);
                        string2 = this.buildTableAlias(string2, vector, n - 1);
                    }
                    this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), jDOFieldDescriptor.getSQLName(), string2, ((JDOFieldDescriptor)fieldDescriptorImpl).getManyTable(), ((JDOFieldDescriptor)fieldDescriptorImpl).getManyKey(), string);
                    this._queryExpr.addInnerJoin(((JDOFieldDescriptor)fieldDescriptorImpl).getManyTable(), ((JDOFieldDescriptor)fieldDescriptorImpl).getSQLName(), string, jDOClassDescriptor2.getTableName(), ((JDOFieldDescriptor)object).getSQLName(), this.buildTableAlias(jDOClassDescriptor2.getTableName(), vector, n));
                }
                jDOClassDescriptor = jDOClassDescriptor2;
            }
            ++n;
        }
    }

    private void addWhereClause(ParseTreeNode parseTreeNode) {
        String string = this.getSQLExpr(parseTreeNode.getChild(0));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf("?", n);
        int n3 = 1;
        while (n2 != -1) {
            int n4 = string.indexOf(" ", n2);
            Integer n5 = null;
            n5 = n4 != -1 ? new Integer(string.substring(n2 + 1, n4)) : new Integer(string.substring(n2 + 1));
            ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n5);
            paramInfo.mapToSQLParam(n3++);
            stringBuffer.append(string.substring(n, n2 + 1));
            n = n4 < 0 ? string.length() : n4;
            n2 = string.indexOf("?", n);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        this._queryExpr.addWhereClause(stringBuffer.toString());
        this._SQLParamIndex = n3;
    }

    private void addLimitClause(ParseTreeNode parseTreeNode) {
        String string = this.getSQLExpr(parseTreeNode);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf("?", n);
        int n3 = this._SQLParamIndex;
        while (n2 != -1) {
            int n4 = string.indexOf(" ", n2);
            Integer n5 = null;
            n5 = n4 != -1 ? new Integer(string.substring(n2 + 1, n4)) : new Integer(string.substring(n2 + 1));
            ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n5);
            paramInfo.mapToSQLParam(n3++);
            stringBuffer.append(string.substring(n, n2 + 1));
            n = n4 < 0 ? string.length() : n4;
            n2 = string.indexOf("?", n);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        this._queryExpr.addLimitClause(stringBuffer.toString());
        this._SQLParamIndex = n3;
    }

    private String getSQLExpr(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = null;
        int n = parseTreeNode.getToken().getTokenType();
        switch (n) {
            case 25: {
                return "( " + this.getSQLExpr(parseTreeNode.getChild(0)) + " )";
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                if (parseTreeNode.getChildCount() == 1) {
                    return parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(0));
                }
                return this.getSQLExpr(parseTreeNode.getChild(0)) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1));
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return this.getSQLExpr(parseTreeNode.getChild(0)) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1));
            }
            case 40: {
                return this.getSQLExpr(parseTreeNode.getChild(0)) + " " + parseTreeNode.getToken().getTokenValue() + " " + this.getSQLExpr(parseTreeNode.getChild(1)) + " AND " + this.getSQLExpr(parseTreeNode.getChild(2));
            }
            case 42: {
                return this.getSQLExpr(parseTreeNode.getChild(0)) + " IS NOT NULL ";
            }
            case 43: {
                return this.getSQLExpr(parseTreeNode.getChild(0)) + " IS NULL ";
            }
            case 50: {
                if (parseTreeNode.getChild(0).getToken().getTokenType() == 20) {
                    return " COUNT(*) ";
                }
                return " COUNT(" + this.getSQLExpr(parseTreeNode.getChild(0)) + ") ";
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return " " + parseTreeNode.getToken().getTokenValue() + "(" + this.getSQLExpr(parseTreeNode.getChild(0)) + ") ";
            }
            case 44: {
                stringBuffer = new StringBuffer("( ");
                Enumeration enumeration = parseTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(this.getSQLExpr((ParseTreeNode)enumeration.nextElement())).append(" , ");
                }
                stringBuffer.replace(stringBuffer.length() - 2, stringBuffer.length() - 1, " )").append(" ");
                return stringBuffer.toString();
            }
            case 2: 
            case 30: {
                String string;
                Object object;
                Object object2;
                if (parseTreeNode.getChildCount() > 0 && parseTreeNode.getChild(0).getToken().getTokenType() == 25) {
                    stringBuffer = new StringBuffer(parseTreeNode.getToken().getTokenValue()).append("(");
                    int n2 = 0;
                    Enumeration enumeration = parseTreeNode.children();
                    enumeration = ((ParseTreeNode)enumeration.nextElement()).children();
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append(this.getSQLExpr((ParseTreeNode)enumeration.nextElement())).append(" , ");
                        ++n2;
                    }
                    if (n2 > 0) {
                        stringBuffer.replace(stringBuffer.length() - 2, stringBuffer.length() - 1, " )");
                    } else {
                        stringBuffer.append(") ");
                    }
                    return stringBuffer.toString();
                }
                Vector vector = (Vector)this._pathInfo.get(parseTreeNode);
                if (n == 30) {
                    if (vector == null) {
                        System.err.println("exprTree=" + parseTreeNode.toStringEx() + "\npathInfo = {");
                        object2 = this._pathInfo.keys();
                        while (object2.hasMoreElements()) {
                            object = (ParseTreeNode)object2.nextElement();
                            System.err.println("\t" + ((ParseTreeNode)object).toStringEx());
                        }
                    }
                    this.addJoinsForPathExpression(vector);
                }
                if ((object2 = (JDOFieldDescriptor)this._fieldInfo.get(parseTreeNode)) == null) {
                    throw new IllegalStateException("fieldInfo for " + parseTreeNode.toStringEx() + " not found");
                }
                object = (JDOClassDescriptor)((FieldDescriptorImpl)object2).getContainingClassDescriptor();
                if (object == null) {
                    throw new IllegalStateException("ContainingClass of " + ((JDOFieldDescriptor)object2).toString() + " is null !");
                }
                if (n == 30 && vector != null && vector.size() > 2) {
                    FieldDescriptorImpl fieldDescriptorImpl;
                    string = this.buildTableAlias(((JDOClassDescriptor)object).getTableName(), vector, vector.size() - 2);
                    JDOClassDescriptor jDOClassDescriptor = this._clsDesc;
                    int n3 = 1;
                    while (n3 < vector.size() - 1) {
                        fieldDescriptorImpl = null;
                        while (fieldDescriptorImpl == null) {
                            fieldDescriptorImpl = jDOClassDescriptor.getField((String)vector.elementAt(n3));
                            if (fieldDescriptorImpl != null) continue;
                            jDOClassDescriptor = (JDOClassDescriptor)jDOClassDescriptor.getExtends();
                        }
                        jDOClassDescriptor = (JDOClassDescriptor)fieldDescriptorImpl.getClassDescriptor();
                        ++n3;
                    }
                    if (!((ClassDescriptorImpl)object).getJavaClass().getName().equals(jDOClassDescriptor.getJavaClass().getName())) {
                        fieldDescriptorImpl = (JDOFieldDescriptor)((ClassDescriptorImpl)object).getIdentity();
                        JDOFieldDescriptor jDOFieldDescriptor = (JDOFieldDescriptor)jDOClassDescriptor.getIdentity();
                        String string2 = this.buildTableAlias(jDOClassDescriptor.getTableName(), vector, vector.size() - 2);
                        this._queryExpr.addInnerJoin(jDOClassDescriptor.getTableName(), jDOFieldDescriptor.getSQLName(), string2, ((JDOClassDescriptor)object).getTableName(), ((JDOFieldDescriptor)fieldDescriptorImpl).getSQLName(), string);
                    }
                } else {
                    string = this.buildTableAlias(((JDOClassDescriptor)object).getTableName(), vector, 9999);
                }
                this._queryExpr.addTable(((JDOClassDescriptor)object).getTableName(), string);
                return this._queryExpr.encodeColumn(string, ((JDOFieldDescriptor)object2).getSQLName()[0]);
            }
            case 27: {
                return "?" + parseTreeNode.getChild(parseTreeNode.getChildCount() - 1).getToken().getTokenValue();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return parseTreeNode.getToken().getTokenValue();
            }
            case 36: {
                stringBuffer = new StringBuffer();
                String string = new String(parseTreeNode.getToken().getTokenValue());
                int n4 = string.indexOf("\\\"", 1);
                while (n4 != -1) {
                    stringBuffer.append(string.substring(0, n4)).append("\"\"");
                    string = string.substring(n4 + 2);
                    n4 = string.indexOf("\\\"");
                }
                stringBuffer.append(string);
                string = stringBuffer.deleteCharAt(0).toString();
                stringBuffer.setLength(0);
                stringBuffer.append("'");
                n4 = string.indexOf("'", 1);
                while (n4 != -1) {
                    stringBuffer.append(string.substring(0, n4)).append("''");
                    string = string.substring(n4 + 1);
                    n4 = string.indexOf("'");
                }
                stringBuffer.append(string);
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "'");
                return stringBuffer.toString();
            }
            case 37: 
            case 38: {
                return parseTreeNode.getToken().getTokenValue().substring(5);
            }
            case 39: {
                return parseTreeNode.getToken().getTokenValue().substring(10);
            }
            case 28: 
            case 29: {
                return " NULL ";
            }
            case 55: {
                return this.getSQLExprForLimit(parseTreeNode);
            }
        }
        return "";
    }

    private String getSQLExprForLimit(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            switch (n) {
                case 27: {
                    stringBuffer.append("?" + parseTreeNode2.getChild(parseTreeNode2.getChildCount() - 1).getToken().getTokenValue());
                    break;
                }
                case 45: {
                    stringBuffer.append(" , ");
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    return parseTreeNode2.getToken().getTokenValue();
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getOrderClause(ParseTreeNode parseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = parseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(", ");
            ParseTreeNode parseTreeNode2 = (ParseTreeNode)enumeration.nextElement();
            int n = parseTreeNode2.getToken().getTokenType();
            switch (n) {
                case 48: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2.getChild(0))).append(" ASC ");
                    break;
                }
                case 49: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2.getChild(0))).append(" DESC ");
                    break;
                }
                case 2: 
                case 30: {
                    stringBuffer.append(this.getSQLExpr(parseTreeNode2)).append(" ");
                }
            }
        }
        stringBuffer.deleteCharAt(0).deleteCharAt(0);
        return stringBuffer.toString();
    }
}

