/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.File;
import java.util.Hashtable;

public class JavaNaming {
    private static final Hashtable subst = JavaNaming.keywordMap();
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    private JavaNaming() {
    }

    public static boolean isKeyword(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < keywords.length) {
            if (keywords[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                if (c >= '0' && c <= '9') {
                    if (n == 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++n;
        }
        return !JavaNaming.isKeyword(string);
    }

    public static String toJavaClassName(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return JavaNaming.toJavaName(string, true);
    }

    public static String toJavaMemberName(String string) {
        return JavaNaming.toJavaMemberName(string, true);
    }

    public static String toJavaMemberName(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = JavaNaming.toJavaName(string, false);
        if (JavaNaming.isKeyword(string2) && bl) {
            String string3 = (String)subst.get(string2);
            string2 = string3 != null ? string3 : "_" + string2;
        }
        return string2;
    }

    public static String packageToPath(String string) {
        if (string == null) {
            return string;
        }
        return string.replace('.', File.separatorChar);
    }

    private static Hashtable keywordMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("class", "type");
        return hashtable;
    }

    private static String toJavaName(String string, boolean bl) {
        boolean bl2;
        int n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        boolean bl3 = bl;
        boolean bl4 = bl2 = !bl3;
        if (n > 1 && bl2 && Character.isUpperCase(cArray[0]) && Character.isUpperCase(cArray[1])) {
            bl2 = false;
        }
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            switch (c) {
                case ' ': 
                case '.': {
                    cArray[n2++] = 95;
                    break;
                }
                case '-': 
                case ':': {
                    bl3 = true;
                    break;
                }
                case '_': {
                    bl3 = true;
                    cArray[n2] = c;
                    ++n2;
                    break;
                }
                default: {
                    if (bl3) {
                        cArray[n2] = Character.toUpperCase(c);
                        bl3 = false;
                    } else if (bl2) {
                        cArray[n2] = Character.toLowerCase(c);
                        bl2 = false;
                    } else {
                        cArray[n2] = c;
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }
}

