/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.schema.DeferredSimpleType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactoryException;
import org.exolab.castor.xml.schema.simpletypes.AtomicType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.castor.xml.schema.simpletypes.RealType;
import org.exolab.castor.xml.schema.simpletypes.UrType;
import org.exolab.castor.xml.schema.simpletypes.factory.Type;
import org.exolab.castor.xml.schema.simpletypes.factory.TypeList;
import org.exolab.castor.xml.schema.simpletypes.factory.TypeProperty;
import org.xml.sax.InputSource;

public class SimpleTypesFactory {
    public static final int INVALID_TYPE = -1;
    public static final int USER_TYPE = 0;
    public static final int STRING_TYPE = 1;
    public static final int DURATION_TYPE = 2;
    public static final int DATETIME_TYPE = 3;
    public static final int TIME_TYPE = 4;
    public static final int DATE_TYPE = 5;
    public static final int GYEARMONTH_TYPE = 6;
    public static final int GYEAR_TYPE = 7;
    public static final int GMONTHDAY_TYPE = 8;
    public static final int GDAY_TYPE = 9;
    public static final int GMONTH_TYPE = 10;
    public static final int BOOLEAN_TYPE = 11;
    public static final int BASE64BINARY_TYPE = 12;
    public static final int HEXBINARY_TYPE = 13;
    public static final int FLOAT_TYPE = 14;
    public static final int DOUBLE_TYPE = 15;
    public static final int DECIMAL_TYPE = 16;
    public static final int ANYURI_TYPE = 17;
    public static final int QNAME_TYPE = 18;
    public static final int NOTATION_TYPE = 19;
    public static final int NORMALIZEDSTRING_TYPE = 20;
    public static final int TOKEN_TYPE = 21;
    public static final int LANGUAGE_TYPE = 22;
    public static final int NAME_TYPE = 23;
    public static final int NCNAME_TYPE = 24;
    public static final int ID_TYPE = 25;
    public static final int IDREF_TYPE = 26;
    public static final int IDREFS_TYPE = 27;
    public static final int ENTITY_TYPE = 28;
    public static final int ENTITIES_TYPE = 29;
    public static final int NMTOKEN_TYPE = 30;
    public static final int NMTOKENS_TYPE = 31;
    public static final int INTEGER_TYPE = 32;
    public static final int NON_POSITIVE_INTEGER_TYPE = 33;
    public static final int NEGATIVE_INTEGER_TYPE = 34;
    public static final int LONG_TYPE = 35;
    public static final int INT_TYPE = 36;
    public static final int SHORT_TYPE = 37;
    public static final int BYTE_TYPE = 38;
    public static final int NON_NEGATIVE_INTEGER_TYPE = 39;
    public static final int UNSIGNED_LONG_TYPE = 40;
    public static final int UNSIGNED_INT_TYPE = 41;
    public static final int UNSIGNED_SHORT_TYPE = 42;
    public static final int UNSIGNED_BYTE_TYPE = 43;
    public static final int POSITIVE_INTEGER_TYPE = 44;
    public static final int ANYSIMPLETYPE_TYPE = 100;
    static final String RESOURCE_LOCATION = "/org/exolab/castor/util/resources/";
    static final String TYPE_MAPPINGS = "/org/exolab/castor/util/resources/SimpleTypesMapping.properties";
    static final String TYPE_DEFINITIONS = "/org/exolab/castor/util/resources/SimpleTypes.properties";
    private static Hashtable _typesByName;
    private static Hashtable _typesByCode;
    private static PrintWriter _logWriter;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$simpletypes$factory$TypeList;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$simpletypes$UrType;

    public static boolean isBuiltInType(int n) {
        return 0 < n;
    }

    public static boolean isPrimitiveType(int n) {
        return 1 <= n && n <= 18;
    }

    public SimpleType getBuiltInType(String string) {
        Type type = this.getType(string);
        if (type == null) {
            return null;
        }
        return type.getSimpleType();
    }

    public String getBuiltInTypeName(int n) {
        Type type = this.getType(n);
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    SimpleType createUserSimpleType(Schema schema, String string, String string2, String string3, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            this.sendToLog(Messages.format("schema.noBaseType", string));
            return null;
        }
        SimpleType simpleType = schema.getSimpleType(string2);
        if (simpleType == null) {
            if (bl) {
                DeferredSimpleType deferredSimpleType = new DeferredSimpleType();
                deferredSimpleType.setSchema(schema);
                deferredSimpleType.setName(string);
                deferredSimpleType.setBaseTypeName(string2);
                deferredSimpleType.setDerivationMethod(string3);
                deferredSimpleType.setTypeCode(0);
                return deferredSimpleType;
            }
            return null;
        }
        return this.createUserSimpleType(schema, string, simpleType, string3);
    }

    SimpleType createUserSimpleType(Schema schema, String string, SimpleType simpleType, String string2) {
        String string3 = string;
        if (string == null) {
            string3 = "anonymous-simple-type";
        }
        if (simpleType == null) {
            this.sendToLog(Messages.format("schema.noBaseType", string3));
            return null;
        }
        SimpleType simpleType2 = null;
        if (string2 != null && string2.equals("list")) {
            if (!(simpleType instanceof AtomicType)) {
                this.sendToLog(Messages.format("schema.deriveByListError", string3, simpleType.getName()));
                return null;
            }
            simpleType2 = new ListType();
            ((ListType)simpleType2).setType((AtomicType)simpleType);
        } else {
            SimpleType simpleType3 = simpleType.getBuiltInBaseType();
            if (simpleType3 == null) {
                this.sendToLog(Messages.format("schema.noBuiltInParent", string3));
                return null;
            }
            simpleType2 = this.createInstance(simpleType3.getName());
            if (simpleType2 == null) {
                throw new RuntimeException(Messages.message("schema.cantLoadBuiltInTypes"));
            }
        }
        simpleType2.setSchema(schema);
        simpleType2.setName(string);
        simpleType2.setBaseType(simpleType);
        simpleType2.setDerivationMethod(string2);
        simpleType2.setTypeCode(0);
        return simpleType2;
    }

    private PrintWriter getLogWriter() {
        return _logWriter;
    }

    private void sendToLog(String string) {
        PrintWriter printWriter = this.getLogWriter();
        if (printWriter != null) {
            printWriter.println(string);
            printWriter.flush();
        }
    }

    private Type getType(String string) {
        if (_typesByName == null) {
            this.loadTypesDefinitions();
        }
        return (Type)_typesByName.get(string);
    }

    private Type getType(int n) {
        if (_typesByCode == null) {
            this.loadTypesDefinitions();
        }
        return (Type)_typesByCode.get(new Integer(n));
    }

    private synchronized void loadTypesDefinitions() {
        if (_typesByName == null && _typesByCode == null) {
            InputStream inputStream = null;
            try {
                Mapping mapping = new Mapping(this.getClass().getClassLoader());
                mapping.setLogWriter(this.getLogWriter());
                inputStream = this.getClass().getResourceAsStream(TYPE_MAPPINGS);
                mapping.loadMapping(new InputSource(inputStream));
                Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$xml$schema$simpletypes$factory$TypeList == null ? (class$org$exolab$castor$xml$schema$simpletypes$factory$TypeList = SimpleTypesFactory.class$("org.exolab.castor.xml.schema.simpletypes.factory.TypeList")) : class$org$exolab$castor$xml$schema$simpletypes$factory$TypeList);
                unmarshaller.setMapping(mapping);
                unmarshaller.setValidation(false);
                inputStream = this.getClass().getResourceAsStream(TYPE_DEFINITIONS);
                TypeList typeList = (TypeList)unmarshaller.unmarshal(new InputSource(inputStream));
                if (Configuration.debug() && this.getLogWriter() != null) {
                    typeList.Print(this.getLogWriter());
                }
                Vector vector = typeList.getTypes();
                _typesByName = new Hashtable();
                _typesByCode = new Hashtable();
                int n = 0;
                while (n < vector.size()) {
                    Type type = (Type)vector.elementAt(n);
                    _typesByName.put(type.getName(), type);
                    type.setSimpleType(this.createSimpleType(type));
                    _typesByCode.put(new Integer(type.getSimpleType().getTypeCode()), type);
                    ++n;
                }
            }
            catch (Exception exception) {
                String string = Messages.message("schema.cantLoadBuiltInTypes") + "; " + exception;
                throw new SimpleTypesFactoryException(exception, string);
            }
        }
    }

    private SimpleType createSimpleType(Type type) {
        int n;
        SimpleType simpleType = this.createInstance(type.getName());
        if (simpleType == null) {
            throw new RuntimeException(Messages.message("schema.cantLoadBuiltInTypes"));
        }
        simpleType.setName(type.getName());
        try {
            n = this.getClass().getDeclaredField(type.getCode()).getInt(null);
        }
        catch (Exception exception) {
            String string = Messages.message("schema.cantLoadBuiltInTypes") + exception;
            throw new SimpleTypesFactoryException(exception, string);
        }
        simpleType.setTypeCode(n);
        if (type.getBase() != null) {
            simpleType.setBaseType(this.getType(type.getBase()).getSimpleType());
        }
        Vector vector = type.getFacet();
        int n2 = 0;
        while (n2 < vector.size()) {
            TypeProperty typeProperty = (TypeProperty)vector.elementAt(n2);
            if (!typeProperty.getPseudo()) {
                simpleType.addFacet(new Facet(typeProperty.getName(), typeProperty.getValue()));
            } else if (new RealType().getClass().isInstance(simpleType)) {
                RealType realType = (RealType)simpleType;
                if (typeProperty.getName().equals("minM")) {
                    realType.setMinMantissa(Long.parseLong(typeProperty.getValue()));
                } else if (typeProperty.getName().equals("maxM")) {
                    realType.setMaxMantissa(Long.parseLong(typeProperty.getValue()));
                } else if (typeProperty.getName().equals("minE")) {
                    realType.setMinExponent(Long.parseLong(typeProperty.getValue()));
                } else if (typeProperty.getName().equals("maxE")) {
                    realType.setMaxExponent(Long.parseLong(typeProperty.getValue()));
                }
            }
            ++n2;
        }
        return simpleType;
    }

    private SimpleType createInstance(String string) {
        SimpleType simpleType;
        Type type = this.getType(string);
        String string2 = type.getDerivedBy();
        ListType listType = null;
        if (string2 != null && string2.equals("list")) {
            listType = new ListType();
        }
        Class clazz = null;
        while (type != null) {
            if (type.getImplClass() != null) {
                clazz = type.getImplClass();
                break;
            }
            type = this.getType(type.getBase());
        }
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(class$org$exolab$castor$xml$schema$simpletypes$UrType == null ? (class$org$exolab$castor$xml$schema$simpletypes$UrType = SimpleTypesFactory.class$("org.exolab.castor.xml.schema.simpletypes.UrType")) : class$org$exolab$castor$xml$schema$simpletypes$UrType)) {
            try {
                simpleType = (UrType)clazz.newInstance();
            }
            catch (Exception exception) {
                simpleType = null;
                exception.printStackTrace();
            }
        } else {
            try {
                simpleType = (AtomicType)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                simpleType = null;
            }
            if (listType != null) {
                listType.setType((AtomicType)simpleType);
                return listType;
            }
        }
        return simpleType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logWriter = new PrintWriter(System.out);
    }
}

