/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.oci.profiler;

import com.netapp.oci.profiler.CsvFileDataStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;

public class TestCsvFileDataStore
extends TestCase {
    private File csvFile;

    public TestCsvFileDataStore(String s) throws Exception {
        super(s);
    }

    protected void setUp() throws Exception {
        this.csvFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "test.csv");
    }

    protected void tearDown() {
        this.csvFile.delete();
    }

    @Test
    public void testCsvDataStore() throws Exception {
        String[] headers = new String[]{"CPU", "Memory", "Originator Start", "Originator End"};
        CsvFileDataStore csvDataStore = new CsvFileDataStore(this.csvFile, headers);
        HashMap<String, Integer> sampleData = new HashMap<String, Integer>();
        sampleData.put("CPU", 12);
        sampleData.put("Memory", 23);
        csvDataStore.store(sampleData);
        csvDataStore.store("Originator Start", (Object)1);
        csvDataStore.store("Originator End", (Object)1);
        csvDataStore.close();
        BufferedReader br = new BufferedReader(new FileReader(this.csvFile));
        String headersLine = br.readLine();
        this.verify(headers, headersLine);
        this.verify(new String[]{"12", "23"}, br.readLine());
        this.verify(new String[]{"", "", "1"}, br.readLine());
        this.verify(new String[]{"", "", "", "1"}, br.readLine());
    }

    private void verify(String[] expectedStrings, String row) {
        Object[] actualContents = row.split(",");
        actualContents = Arrays.copyOfRange(actualContents, 1, actualContents.length);
        Assert.assertTrue((boolean)Arrays.equals(expectedStrings, actualContents));
    }
}

