/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject(creatable=false, amqpName="org.apache.qpid.Session")
public interface Session<X extends Session<X>>
extends ConfiguredObject<X> {
    public static final String CHANNEL_ID = "channelId";
    public static final String PRODUCER_FLOW_BLOCKED = "producerFlowBlocked";
    public static final String TRANSACTION_TIMEOUT_NOTIFICATION_REPEAT_PERIOD = "qpid.session.transactionTimeoutNotificationRepeatPeriod";
    @ManagedContextDefault(name="qpid.session.transactionTimeoutNotificationRepeatPeriod", description="Frequency, in milliseconds, with which transaction timeout warnings will be repeated.")
    public static final long TRANSACTION_TIMEOUT_NOTIFICATION_REPEAT_PERIOD_DEFAULT = 10000L;
    public static final String PRODUCER_AUTH_CACHE_SIZE = "producer.authCacheSize";
    @ManagedContextDefault(name="producer.authCacheSize", description="Maximum number of distinct destinations for which a cached auth value may be held")
    public static final int PRODUCER_AUTH_CACHE_SIZE_DEFAULT = 20;
    public static final String PRODUCER_AUTH_CACHE_TIMEOUT = "producer.authCacheTimeout";
    @ManagedContextDefault(name="producer.authCacheTimeout", description="Maximum time, in milliseconds, for which a cached auth value may be retained")
    public static final long PRODUCER_AUTH_CACHE_TIMEOUT_DEFAULT = 300000L;

    @DerivedAttribute
    public int getChannelId();

    @DerivedAttribute
    public boolean isProducerFlowBlocked();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers")
    public long getConsumerCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetched")
    public long getUnacknowledgedMessages();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false, skipAclCheck=true)
    public Set<? extends Consumer<?, ?>> getConsumers();
}

