/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.EnumSet;

public enum Transport {
    TCP,
    SSL(true),
    WS,
    WSS(true),
    SCTP;

    private boolean _secure;

    private Transport() {
        this(false);
    }

    private Transport(boolean secure) {
        this._secure = secure;
    }

    public final boolean isSecure() {
        return this._secure;
    }

    public static Transport valueOfObject(Object transportObject) {
        Transport transport;
        if (transportObject instanceof Transport) {
            transport = (Transport)((Object)transportObject);
        } else {
            try {
                transport = Transport.valueOf(String.valueOf(transportObject));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't convert '" + transportObject + "' to one of the supported transports: " + EnumSet.allOf(Transport.class), e);
            }
        }
        return transport;
    }
}

