/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Comparator;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Port;

@ManagedObject(creatable=false)
public interface VirtualHostAlias<X extends VirtualHostAlias<X>>
extends ConfiguredObject<X> {
    public static final Comparator<VirtualHostAlias> COMPARATOR = new Comparator<VirtualHostAlias>(){

        @Override
        public int compare(VirtualHostAlias left, VirtualHostAlias right) {
            int comparison = left.getPriority() - right.getPriority();
            if (comparison == 0) {
                long rightTime;
                long leftTime = left.getCreatedTime() == null ? 0L : left.getCreatedTime().getTime();
                long createCompare = leftTime - (rightTime = right.getCreatedTime() == null ? 0L : right.getCreatedTime().getTime());
                comparison = createCompare == 0L ? left.getName().compareTo(right.getName()) : (createCompare < 0L ? -1 : 1);
            }
            return comparison;
        }
    };
    public static final String PRIORITY = "priority";

    public Port getPort();

    @ManagedAttribute(defaultValue="100")
    public int getPriority();

    public NamedAddressSpace getAddressSpace(String var1);
}

