/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.OverflowPolicyHandler;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.session.AMQPSession;

public class ProducerFlowControlOverflowPolicyHandler
implements OverflowPolicyHandler {
    private final Handler _handler;

    ProducerFlowControlOverflowPolicyHandler(Queue<?> queue, EventLogger eventLogger) {
        this._handler = new Handler(queue, eventLogger);
        queue.addChangeListener(this._handler);
    }

    boolean isQueueFlowStopped() {
        return this._handler.isQueueFlowStopped();
    }

    @Override
    public void checkOverflow(QueueEntry newlyEnqueued) {
        this._handler.checkOverflow(newlyEnqueued);
    }

    private static class Handler
    extends AbstractConfigurationChangeListener {
        private final Queue<?> _queue;
        private final EventLogger _eventLogger;
        private final AtomicBoolean _overfullReported = new AtomicBoolean(false);
        private final Set<AMQPSession<?, ?>> _blockedSessions = Collections.newSetFromMap(new ConcurrentHashMap());
        private volatile double _queueFlowResumeLimit;
        private boolean _checkCapacity;

        private Handler(Queue<?> queue, EventLogger eventLogger) {
            this._queue = queue;
            this._eventLogger = eventLogger;
            Double value = this._queue.getContextValue(Double.class, "queue.queueFlowResumeLimit");
            if (value != null) {
                this._queueFlowResumeLimit = value;
            }
        }

        private void checkOverflow(QueueEntry newlyEnqueued) {
            long maximumQueueDepthBytes = this._queue.getMaximumQueueDepthBytes();
            long maximumQueueDepthMessages = this._queue.getMaximumQueueDepthMessages();
            if (maximumQueueDepthBytes >= 0L || maximumQueueDepthMessages >= 0L) {
                this.checkOverfull(maximumQueueDepthBytes, maximumQueueDepthMessages);
            }
            this.checkUnderfull(maximumQueueDepthBytes, maximumQueueDepthMessages);
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            super.attributeSet(object, attributeName, oldAttributeValue, newAttributeValue);
            if ("context".equals(attributeName)) {
                double queueFlowResumePercentage;
                Double value = this._queue.getContextValue(Double.class, "queue.queueFlowResumeLimit");
                double d = queueFlowResumePercentage = value == null ? 0.0 : value;
                if (queueFlowResumePercentage != this._queueFlowResumeLimit) {
                    this._queueFlowResumeLimit = queueFlowResumePercentage;
                    this._checkCapacity = true;
                }
            }
            if ("maximumQueueDepthBytes".equals(attributeName) || "maximumQueueDepthMessages".equals(attributeName)) {
                this._checkCapacity = true;
            }
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            super.bulkChangeEnd(object);
            if (this._queue.getOverflowPolicy() == OverflowPolicy.PRODUCER_FLOW_CONTROL) {
                if (this._checkCapacity) {
                    this._checkCapacity = false;
                    this.checkUnderfull(this._queue.getMaximumQueueDepthBytes(), this._queue.getMaximumQueueDepthMessages());
                }
            } else {
                this._queue.removeChangeListener(this);
                this.checkUnderfull(-1L, -1L);
            }
        }

        boolean isQueueFlowStopped() {
            return this._overfullReported.get();
        }

        private void checkUnderfull(long maximumQueueDepthBytes, long maximumQueueDepthMessages) {
            long queueDepthBytes = this._queue.getQueueDepthBytes();
            long queueDepthMessages = this._queue.getQueueDepthMessages();
            if (this.isUnderfull(queueDepthBytes, maximumQueueDepthBytes) && this.isUnderfull(queueDepthMessages, maximumQueueDepthMessages)) {
                if (this._overfullReported.compareAndSet(true, false)) {
                    this._eventLogger.message(this._queue.getLogSubject(), QueueMessages.UNDERFULL(queueDepthBytes, this.getFlowResumeLimit(maximumQueueDepthBytes), queueDepthMessages, this.getFlowResumeLimit(maximumQueueDepthMessages)));
                }
                for (AMQPSession<?, ?> blockedSession : this._blockedSessions) {
                    blockedSession.unblock(this._queue);
                    this._blockedSessions.remove(blockedSession);
                }
            }
        }

        private void checkOverfull(long maximumQueueDepthBytes, long maximumQueueDepthMessages) {
            SessionPrincipal sessionPrincipal;
            Subject subject;
            Set<SessionPrincipal> sessionPrincipals;
            long queueDepthBytes = this._queue.getQueueDepthBytes();
            long queueDepthMessages = this._queue.getQueueDepthMessages();
            if ((maximumQueueDepthBytes >= 0L && queueDepthBytes > maximumQueueDepthBytes || maximumQueueDepthMessages >= 0L && queueDepthMessages > maximumQueueDepthMessages) && !(sessionPrincipals = (subject = Subject.getSubject(AccessController.getContext())).getPrincipals(SessionPrincipal.class)).isEmpty() && (sessionPrincipal = sessionPrincipals.iterator().next()) != null) {
                if (this._overfullReported.compareAndSet(false, true)) {
                    this._eventLogger.message(this._queue.getLogSubject(), QueueMessages.OVERFULL(queueDepthBytes, maximumQueueDepthBytes, queueDepthMessages, maximumQueueDepthMessages));
                }
                AMQPSession<?, ?> session = sessionPrincipal.getSession();
                this._blockedSessions.add(session);
                session.block(this._queue);
            }
        }

        private boolean isUnderfull(long queueDepth, long maximumQueueDepth) {
            return maximumQueueDepth < 0L || queueDepth <= this.getFlowResumeLimit(maximumQueueDepth);
        }

        private long getFlowResumeLimit(long maximumQueueDepth) {
            if (maximumQueueDepth >= 0L) {
                return (long)Math.ceil(this._queueFlowResumeLimit / 100.0 * (double)maximumQueueDepth);
            }
            return -1L;
        }
    }
}

