/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TrustStoreMessages;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.CertificateDetailsImpl;
import org.apache.qpid.server.security.TrustAnchorValidatingTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrustStore<X extends AbstractTrustStore<X>>
extends AbstractConfiguredObject<X>
implements TrustStore<X> {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractTrustStore.class);
    protected static final long ONE_DAY = 86400000L;
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private boolean _exposedAsMessageSource;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _includedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _excludedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private boolean _trustAnchorValidityEnforced;
    @ManagedAttributeField
    private boolean _certificateRevocationCheckEnabled;
    @ManagedAttributeField
    private boolean _certificateRevocationCheckOfOnlyEndEntityCertificates;
    @ManagedAttributeField
    private boolean _certificateRevocationCheckWithPreferringCertificateRevocationList;
    @ManagedAttributeField
    private boolean _certificateRevocationCheckWithNoFallback;
    @ManagedAttributeField
    private boolean _certificateRevocationCheckWithIgnoringSoftFailures;
    @ManagedAttributeField(afterSet="postSetCertificateRevocationListUrl")
    private volatile String _certificateRevocationListUrl;
    private volatile String _certificateRevocationListPath;
    private ScheduledFuture<?> _checkExpiryTaskFuture;

    AbstractTrustStore(Map<String, Object> attributes, Broker<?> broker) {
        super(broker, attributes);
        this._broker = broker;
        this._eventLogger = broker.getEventLogger();
        this._eventLogger.message(TrustStoreMessages.CREATE(this.getName()));
    }

    public final Broker<?> getBroker() {
        return this._broker;
    }

    final EventLogger getEventLogger() {
        return this._eventLogger;
    }

    protected abstract void initialize();

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("certificateRevocationListUrl")) {
            this.initialize();
        }
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.getCRLs();
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("certificateRevocationListUrl")) {
            this.getCRLs((String)proxyForValidation.getAttribute("certificateRevocationListUrl"));
        }
    }

    @Override
    protected ListenableFuture<Void> onClose() {
        this.onCloseOrDelete();
        return Futures.immediateFuture(null);
    }

    private void onCloseOrDelete() {
        if (this._checkExpiryTaskFuture != null) {
            this._checkExpiryTaskFuture.cancel(false);
            this._checkExpiryTaskFuture = null;
        }
    }

    @Override
    protected void logOperation(String operation) {
        this._broker.getEventLogger().message(TrustStoreMessages.OPERATION(operation));
    }

    void initializeExpiryChecking() {
        int checkFrequency = this.getCertificateExpiryCheckFrequency();
        if (this.getBroker().getState() == State.ACTIVE) {
            this._checkExpiryTaskFuture = this.getBroker().scheduleHouseKeepingTask(checkFrequency, TimeUnit.DAYS, this::checkCertificateExpiry);
        } else {
            final int frequency = checkFrequency;
            this.getBroker().addChangeListener(new AbstractConfigurationChangeListener(){

                @Override
                public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                    if (newState == State.ACTIVE) {
                        AbstractTrustStore.this._checkExpiryTaskFuture = AbstractTrustStore.this.getBroker().scheduleHouseKeepingTask(frequency, TimeUnit.DAYS, () -> AbstractTrustStore.this.checkCertificateExpiry());
                        AbstractTrustStore.this.getBroker().removeChangeListener(this);
                    }
                }
            });
        }
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this.onCloseOrDelete();
        this._eventLogger.message(TrustStoreMessages.DELETE(this.getName()));
        return super.onDelete();
    }

    private void checkCertificateExpiry() {
        int expiryWarning = this.getCertificateExpiryWarnPeriod();
        if (expiryWarning > 0) {
            long currentTime = System.currentTimeMillis();
            Date expiryTestDate = new Date(currentTime + 86400000L * (long)expiryWarning);
            try {
                Certificate[] certificatesInternal = this.getCertificates();
                if (certificatesInternal.length > 0) {
                    Arrays.stream(certificatesInternal).filter(cert -> cert instanceof X509Certificate).forEach(x509cert -> this.checkCertificateExpiry(currentTime, expiryTestDate, (X509Certificate)x509cert));
                }
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug("Unexpected exception whilst checking certificate expiry", (Throwable)e);
            }
        }
    }

    private void checkCertificateExpiry(long currentTime, Date expiryTestDate, X509Certificate cert) {
        try {
            cert.checkValidity(expiryTestDate);
        }
        catch (CertificateExpiredException e) {
            long timeToExpiry = cert.getNotAfter().getTime() - currentTime;
            int days = Math.max(0, (int)(timeToExpiry / 86400000L));
            this.getEventLogger().message(TrustStoreMessages.EXPIRING(this.getName(), String.valueOf(days), cert.getSubjectDN().toString()));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
    }

    @Override
    public final TrustManager[] getTrustManagers() throws GeneralSecurityException {
        if (this.isTrustAnchorValidityEnforced()) {
            HashSet trustManagerCerts = Sets.newHashSet((Object[])this.getCertificates());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            HashSet<Certificate> otherCerts = new HashSet<Certificate>();
            for (Certificate certs : trustManagerCerts) {
                if (certs instanceof X509Certificate && this.isSelfSigned((X509Certificate)certs)) {
                    trustAnchors.add(new TrustAnchor((X509Certificate)certs, null));
                    continue;
                }
                otherCerts.add(certs);
            }
            TrustManager[] trustManagers = this.getTrustManagersInternal();
            TrustManager[] wrappedTrustManagers = new TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                TrustManager trustManager = trustManagers[i];
                wrappedTrustManagers[i] = trustManager instanceof X509TrustManager ? new TrustAnchorValidatingTrustManager(this.getName(), (X509TrustManager)trustManager, trustAnchors, otherCerts) : trustManager;
            }
            return wrappedTrustManagers;
        }
        return this.getTrustManagersInternal();
    }

    protected abstract TrustManager[] getTrustManagersInternal() throws GeneralSecurityException;

    protected TrustManager[] getTrustManagers(KeyStore ts) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(new CertPathTrustManagerParameters(this.getParameters(ts)));
            return tmf.getTrustManagers();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Cannot create trust manager factory for truststore '" + this.getName() + "' :" + e, e);
        }
    }

    private CertPathParameters getParameters(KeyStore trustStore) {
        try {
            PKIXBuilderParameters parameters = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            parameters.setRevocationEnabled(this._certificateRevocationCheckEnabled);
            if (this._certificateRevocationCheckEnabled) {
                if (this._certificateRevocationListUrl != null) {
                    parameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.getCRLs())));
                }
                PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)CertPathBuilder.getInstance(TrustManagerFactory.getDefaultAlgorithm()).getRevocationChecker();
                HashSet<PKIXRevocationChecker.Option> options = new HashSet<PKIXRevocationChecker.Option>();
                if (this._certificateRevocationCheckOfOnlyEndEntityCertificates) {
                    options.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
                }
                if (this._certificateRevocationCheckWithPreferringCertificateRevocationList) {
                    options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
                }
                if (this._certificateRevocationCheckWithNoFallback) {
                    options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
                }
                if (this._certificateRevocationCheckWithIgnoringSoftFailures) {
                    options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
                }
                revocationChecker.setOptions(options);
                parameters.addCertPathChecker(revocationChecker);
            }
            return parameters;
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Cannot create trust manager factory parameters for truststore '" + this.getName() + "' :" + e, e);
        }
    }

    private Collection<? extends CRL> getCRLs() {
        return this.getCRLs(this._certificateRevocationListUrl);
    }

    private Collection<? extends CRL> getCRLs(String crlUrl) {
        Collection<Object> crls = Collections.emptyList();
        if (crlUrl != null) {
            try (InputStream is = AbstractTrustStore.getUrlFromString(crlUrl).openStream();){
                crls = SSLUtil.getCertificateFactory().generateCRLs(is);
            }
            catch (IOException | CRLException e) {
                throw new IllegalConfigurationException("Unable to load certificate revocation list '" + crlUrl + "' for truststore '" + this.getName() + "' :" + e, e);
            }
        }
        return crls;
    }

    protected static URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    @Override
    public final int getCertificateExpiryWarnPeriod() {
        try {
            return this.getContextValue(Integer.class, "qpid.truststore.certificateExpiryWarnPeriod");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.warn("The value of the context variable '{}' for truststore {} cannot be converted to an integer. The value {} will be used as a default", new Object[]{"qpid.truststore.certificateExpiryWarnPeriod", this.getName(), 30});
            return 30;
        }
    }

    @Override
    public int getCertificateExpiryCheckFrequency() {
        int checkFrequency;
        try {
            checkFrequency = this.getContextValue(Integer.class, "qpid.truststore.certificateExpiryCheckFrequency");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.warn("Cannot parse the context variable {} ", (Object)"qpid.truststore.certificateExpiryCheckFrequency", (Object)e);
            checkFrequency = 1;
        }
        return checkFrequency;
    }

    @Override
    public boolean isTrustAnchorValidityEnforced() {
        return this._trustAnchorValidityEnforced;
    }

    @Override
    public boolean isCertificateRevocationCheckEnabled() {
        return this._certificateRevocationCheckEnabled;
    }

    @Override
    public boolean isCertificateRevocationCheckOfOnlyEndEntityCertificates() {
        return this._certificateRevocationCheckOfOnlyEndEntityCertificates;
    }

    @Override
    public boolean isCertificateRevocationCheckWithPreferringCertificateRevocationList() {
        return this._certificateRevocationCheckWithPreferringCertificateRevocationList;
    }

    @Override
    public boolean isCertificateRevocationCheckWithNoFallback() {
        return this._certificateRevocationCheckWithNoFallback;
    }

    @Override
    public boolean isCertificateRevocationCheckWithIgnoringSoftFailures() {
        return this._certificateRevocationCheckWithIgnoringSoftFailures;
    }

    @Override
    public String getCertificateRevocationListUrl() {
        return this._certificateRevocationListUrl;
    }

    @Override
    public String getCertificateRevocationListPath() {
        return this._certificateRevocationListPath;
    }

    private void postSetCertificateRevocationListUrl() {
        this._certificateRevocationListPath = this._certificateRevocationListUrl != null && !this._certificateRevocationListUrl.startsWith("data:") ? this._certificateRevocationListUrl : null;
    }

    @Override
    public boolean isExposedAsMessageSource() {
        return this._exposedAsMessageSource;
    }

    @Override
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources() {
        return this._includedVirtualHostNodeMessageSources;
    }

    @Override
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources() {
        return this._excludedVirtualHostNodeMessageSources;
    }

    @Override
    public List<CertificateDetails> getCertificateDetails() {
        try {
            Certificate[] certificatesInternal = this.getCertificates();
            if (certificatesInternal.length > 0) {
                return Arrays.stream(certificatesInternal).filter(cert -> cert instanceof X509Certificate).map(x509cert -> new CertificateDetailsImpl((X509Certificate)x509cert)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalConfigurationException("Failed to extract certificate details", e);
        }
    }

    private boolean isSelfSigned(X509Certificate cert) throws GeneralSecurityException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (InvalidKeyException | SignatureException e) {
            return false;
        }
    }
}

