/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.qpid.server.model.ManagedAttributeValue;
import org.apache.qpid.server.security.CertificateDetails;

public class CertificateDetailsImpl
implements CertificateDetails,
ManagedAttributeValue {
    private final X509Certificate _x509cert;

    public CertificateDetailsImpl(X509Certificate x509cert) {
        this._x509cert = x509cert;
    }

    @Override
    public String getSerialNumber() {
        return this._x509cert.getSerialNumber().toString();
    }

    @Override
    public int getVersion() {
        return this._x509cert.getVersion();
    }

    @Override
    public String getSignatureAlgorithm() {
        return this._x509cert.getSigAlgName();
    }

    @Override
    public String getIssuerName() {
        return this._x509cert.getIssuerX500Principal().getName();
    }

    @Override
    public String getSubjectName() {
        return this._x509cert.getSubjectX500Principal().getName();
    }

    @Override
    public List<String> getSubjectAltNames() {
        try {
            ArrayList<String> altNames = new ArrayList<String>();
            Collection<List<?>> altNameObjects = this._x509cert.getSubjectAlternativeNames();
            if (altNameObjects != null) {
                for (List<?> entry : altNameObjects) {
                    int type = (Integer)entry.get(0);
                    if (type != 1 && type != 2) continue;
                    altNames.add(entry.get(1).toString().trim());
                }
            }
            return altNames;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Date getValidFrom() {
        return this._x509cert.getNotBefore();
    }

    @Override
    public Date getValidUntil() {
        return this._x509cert.getNotAfter();
    }
}

