/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class StringUtil {
    private static final String NUMBERS = "0123456789";
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxwy";
    private static final String OTHERS = "_-";
    private static final char[] CHARACTERS = ("0123456789abcdefghijklmnopqrstuvwxwy" + "abcdefghijklmnopqrstuvwxwy".toUpperCase() + "_-").toCharArray();
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private Random _random = new Random();

    public static String elideDataUrl(String path) {
        return String.valueOf(path).toLowerCase().startsWith("data:") ? "data:..." : path;
    }

    public static String toHex(byte[] bin) {
        StringBuilder result = new StringBuilder(2 * bin.length);
        for (byte b : bin) {
            result.append(HEX[b >> 4 & 0xF]);
            result.append(HEX[b & 0xF]);
        }
        return result.toString();
    }

    public String randomAlphaNumericString(int maxLength) {
        char[] result = new char[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            result[i] = CHARACTERS[this._random.nextInt(CHARACTERS.length)];
        }
        return new String(result);
    }

    public String createUniqueJavaName(String managerName) {
        StringBuilder builder = new StringBuilder();
        boolean initialChar = true;
        for (int i = 0; i < managerName.length(); ++i) {
            char c = managerName.charAt(i);
            if ((!initialChar || !Character.isJavaIdentifierStart(c)) && (initialChar || !Character.isJavaIdentifierPart(c))) continue;
            builder.append(c);
            initialChar = false;
        }
        if (builder.length() > 0) {
            builder.append("_");
        }
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(managerName.getBytes(StandardCharsets.UTF_8));
            builder.append(StringUtil.toHex(digest).toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerScopedRuntimeException(e);
        }
        return builder.toString();
    }
}

