/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.virtualhost.AbstractSystemMessageSource;

public class VirtualHostPropertiesNode
extends AbstractSystemMessageSource {
    public VirtualHostPropertiesNode(NamedAddressSpace virtualHost) {
        this(virtualHost, "$virtualhostProperties");
    }

    public VirtualHostPropertiesNode(NamedAddressSpace virtualHost, String name) {
        super(name, virtualHost);
    }

    @Override
    public <T extends ConsumerTarget<T>> AbstractSystemMessageSource.Consumer<T> addConsumer(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused, MessageSource.QueueDeleted {
        MessageInstanceConsumer consumer = super.addConsumer((ConsumerTarget)target, filters, (Class)messageClass, consumerName, (EnumSet)options, priority);
        ((AbstractSystemMessageSource.Consumer)consumer).send(this.createMessage());
        target.noMessagesAvailable();
        return consumer;
    }

    @Override
    public void close() {
    }

    protected InternalMessage createMessage() {
        String primaryDomain;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        List<String> globalAddressDomains = this._addressSpace.getGlobalAddressDomains();
        if (globalAddressDomains != null && !globalAddressDomains.isEmpty() && (primaryDomain = globalAddressDomains.get(0)) != null) {
            if (!(primaryDomain = primaryDomain.trim()).endsWith("/")) {
                primaryDomain = primaryDomain + "/";
            }
            headers.put("virtualHost.temporaryQueuePrefix", primaryDomain);
        }
        InternalMessageHeader header = new InternalMessageHeader(headers, null, 0L, null, null, UUID.randomUUID().toString(), null, null, 4, System.currentTimeMillis(), 0L, null, null, System.currentTimeMillis());
        InternalMessage message = InternalMessage.createBytesMessage(this._addressSpace.getMessageStore(), header, new byte[0]);
        message.setInitialRoutingAddress(this.getName());
        return message;
    }
}

