/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ant.compress.resources.CommonsCompressArchiveResource;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.ant.compress.util.ZipStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.util.FileUtils;

public final class ZipResource
extends CommonsCompressArchiveResource {
    private ZipExtraField[] extras;
    private int method;
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$FileProvider;

    public ZipResource() {
        super(new ZipStreamFactory(), "zip");
    }

    public ZipResource(File z, String enc, ZipArchiveEntry e) {
        super((ArchiveStreamFactory)new ZipStreamFactory(), "zip", z, (ArchiveEntry)e);
        this.setEncoding(enc);
        this.setEntry((ArchiveEntry)e);
    }

    public ZipResource(Resource z, String enc, ZipArchiveEntry e) {
        super((ArchiveStreamFactory)new ZipStreamFactory(), "zip", z, (ArchiveEntry)e);
        this.setEncoding(enc);
        this.setEntry((ArchiveEntry)e);
    }

    public void setZipfile(File z) {
        this.setArchive(z);
    }

    public void setZipResource(Resource z) {
        this.addConfigured((ResourceCollection)z);
    }

    public File getZipfile() {
        FileProvider fp = (FileProvider)this.getArchive().as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ZipResource.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider);
        return fp != null ? fp.getFile() : null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        File f = this.getZipfile();
        if (f == null) {
            return super.getInputStream();
        }
        final ZipFile z = new ZipFile(f, this.getEncoding());
        ZipArchiveEntry ze = z.getEntry(this.getName());
        if (ze == null) {
            z.close();
            throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
        }
        return new FilterInputStream(z.getInputStream(ze)){

            public void close() throws IOException {
                FileUtils.close((InputStream)this.in);
                z.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
    }

    public ZipExtraField[] getExtraFields() {
        if (this.isReference()) {
            return ((ZipResource)((Object)this.getCheckedRef())).getExtraFields();
        }
        this.checkEntry();
        if (this.extras == null) {
            return new ZipExtraField[0];
        }
        return this.extras;
    }

    public int getMethod() {
        return this.method;
    }

    protected void fetchEntry() {
        File f = this.getZipfile();
        if (f == null) {
            super.fetchEntry();
            return;
        }
        ZipFile z = null;
        try {
            z = new ZipFile(this.getZipfile(), this.getEncoding());
            this.setEntry((ArchiveEntry)z.getEntry(this.getName()));
        }
        catch (IOException e) {
            try {
                this.log(e.getMessage(), 4);
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(z);
                throw throwable;
            }
        }
        ZipFile.closeQuietly((ZipFile)z);
    }

    protected void setEntry(ArchiveEntry e) {
        super.setEntry(e);
        if (e != null) {
            ZipArchiveEntry ze = (ZipArchiveEntry)e;
            this.extras = ze.getExtraFields(true);
            this.method = ze.getMethod();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

