/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniquePropertiesCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "properties.duplicateproperty";
    public static final String IO_EXCEPTION_KEY = "unable.open.cause";

    public UniquePropertiesCheck() {
        super.setFileExtensions(new String[]{"properties"});
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        UniqueProperties properties = new UniqueProperties();
        try {
            properties.load(new FileInputStream(aFile));
        }
        catch (IOException e) {
            this.log(0, IO_EXCEPTION_KEY, aFile.getPath(), e.getLocalizedMessage());
        }
        for (Multiset.Entry duplication : properties.getDuplicatedStrings().entrySet()) {
            String keyName = (String)duplication.getElement();
            int lineNumber = this.getLineNumber(aLines, keyName);
            this.log(lineNumber, MSG_KEY, keyName, duplication.getCount() + 1);
        }
    }

    protected int getLineNumber(List<String> aLines, String aKeyNane) {
        String keyPatternString = "^" + aKeyNane.replace(" ", "\\\\ ") + "[\\s:=].*$";
        Pattern keyPattern = Pattern.compile(keyPatternString);
        int lineNumber = 1;
        Matcher matcher = keyPattern.matcher("");
        for (String line : aLines) {
            matcher.reset(line);
            if (matcher.matches()) break;
            ++lineNumber;
        }
        if (lineNumber > aLines.size()) {
            lineNumber = 0;
        }
        return lineNumber;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UniqueProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Multiset<String> mDuplicatedStrings = HashMultiset.create();

        private UniqueProperties() {
        }

        @Override
        public synchronized Object put(Object aKey, Object aValue) {
            Object oldValue = super.put(aKey, aValue);
            if (oldValue != null && aKey instanceof String) {
                String keyString = (String)aKey;
                this.mDuplicatedStrings.add((Object)keyString);
            }
            return oldValue;
        }

        public Multiset<String> getDuplicatedStrings() {
            return this.mDuplicatedStrings;
        }
    }
}

