/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;

public class InnerAssignmentCheck
extends Check {
    private static final int[][] ALLOWED_ASSIGMENT_CONTEXT = new int[][]{{28, 7}, {10}, {28, 34, 35}, {28, 34, 37}, {160}, {178, 177, 176}};
    private static final int[][] CONTROL_CONTEXT = new int[][]{{28, 85}, {28, 91}, {28, 84}, {28, 83}, {28, 92}};
    private static final int[][] ALLOWED_ASSIGMENT_IN_COMPARISON_CONTEXT = new int[][]{{28, 84}};
    private static final int[] COMPARISON_TYPES = new int[]{116, 120, 118, 119, 117, 115};

    public int[] getDefaultTokens() {
        return new int[]{80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    public void visitToken(DetailAST aAST) {
        if (InnerAssignmentCheck.isInContext(aAST, ALLOWED_ASSIGMENT_CONTEXT)) {
            return;
        }
        if (InnerAssignmentCheck.isInNoBraceControlStatement(aAST)) {
            return;
        }
        if (this.isInWhileIdiom(aAST)) {
            return;
        }
        this.log(aAST.getLineNo(), aAST.getColumnNo(), "assignment.inner.avoid", new Object[0]);
    }

    private static boolean isInNoBraceControlStatement(DetailAST aAST) {
        if (!InnerAssignmentCheck.isInContext(aAST, CONTROL_CONTEXT)) {
            return false;
        }
        DetailAST expr = aAST.getParent();
        DetailAST exprNext = expr.getNextSibling();
        return exprNext != null && exprNext.getType() == 45;
    }

    private boolean isInWhileIdiom(DetailAST aAST) {
        if (!InnerAssignmentCheck.isComparison(aAST.getParent())) {
            return false;
        }
        return InnerAssignmentCheck.isInContext(aAST.getParent(), ALLOWED_ASSIGMENT_IN_COMPARISON_CONTEXT);
    }

    private static boolean isComparison(DetailAST aAST) {
        int astType = aAST.getType();
        return Arrays.binarySearch(COMPARISON_TYPES, astType) >= 0;
    }

    private static boolean isInContext(DetailAST aAST, int[][] aContextSet) {
        block0: for (int[] element : aContextSet) {
            DetailAST current = aAST;
            int len = element.length;
            for (int j = 0; j < len; ++j) {
                current = current.getParent();
                int expectedType = element[j];
                if (current == null || current.getType() != expectedType) continue block0;
                if (j != len - 1) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Arrays.sort(COMPARISON_TYPES);
    }
}

