/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.impl.logging;

import com.blackducksoftware.sdk.impl.logging.LoggingMessageSecure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractPayloadFilteredLoggingInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private int limit = 102400;
    private PrintWriter writer;

    public AbstractPayloadFilteredLoggingInInterceptor() {
        super("receive");
    }

    public AbstractPayloadFilteredLoggingInInterceptor(String string) {
        super(string);
    }

    public AbstractPayloadFilteredLoggingInInterceptor(int n) {
        this();
        this.limit = n;
    }

    public AbstractPayloadFilteredLoggingInInterceptor(PrintWriter printWriter) {
        this();
        this.writer = printWriter;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.writer != null || this.getLogger().isLoggable(Level.INFO)) {
            this.logging(message);
        }
    }

    private void logging(Message message) throws Fault {
        InputStream inputStream;
        String string;
        Object object;
        String string2;
        String string3 = (String)message.getExchange().get((Object)LoggingMessageSecure.ID_KEY);
        if (string3 == null) {
            string3 = LoggingMessageSecure.nextId();
            message.getExchange().put((Object)LoggingMessageSecure.ID_KEY, (Object)string3);
        }
        LoggingMessageSecure loggingMessageSecure = this.createNewLoggingMessage(string3);
        String string4 = (String)message.get((Object)Message.ENCODING);
        if (string4 != null) {
            loggingMessageSecure.getEncoding().append(string4);
        }
        if ((string2 = (String)message.get((Object)"Content-Type")) != null) {
            loggingMessageSecure.getContentType().append(string2);
        }
        if ((object = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            loggingMessageSecure.getHeader().append(object);
        }
        if ((string = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            loggingMessageSecure.getAddress().append(string);
        }
        if ((inputStream = (InputStream)message.getContent(InputStream.class)) != null) {
            CachedOutputStream cachedOutputStream = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)cachedOutputStream);
                cachedOutputStream.flush();
                inputStream.close();
                message.setContent(InputStream.class, (Object)cachedOutputStream.getInputStream());
                if (cachedOutputStream.getTempFile() != null) {
                    loggingMessageSecure.getMessage().append("\nMessage (saved to tmp file):\n");
                    loggingMessageSecure.getMessage().append("Filename: " + cachedOutputStream.getTempFile().getAbsolutePath() + "\n");
                }
                if (cachedOutputStream.size() > this.limit) {
                    loggingMessageSecure.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                cachedOutputStream.writeCacheTo(loggingMessageSecure.getPayload(), this.limit);
                cachedOutputStream.close();
            }
            catch (IOException iOException) {
                throw new Fault((Throwable)iOException);
            }
        }
        if (this.writer != null) {
            this.writer.println(loggingMessageSecure.toString());
        } else if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info(loggingMessageSecure.toString());
        }
    }

    abstract Logger getLogger();

    abstract LoggingMessageSecure createNewLoggingMessage(String var1);
}

