/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.impl.logging;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class LoggingMessageSecure {
    public static final String ID_KEY = LoggingMessageSecure.class.getName() + ".ID";
    private static final AtomicInteger ID = new AtomicInteger();
    private final String logHeading;
    private final StringBuilder address = new StringBuilder();
    private final StringBuilder contentType = new StringBuilder();
    private final StringBuilder encoding = new StringBuilder();
    private final StringBuilder header = new StringBuilder();
    private final StringBuilder message = new StringBuilder();
    private final StringBuilder payload = new StringBuilder();
    private final String id;

    public LoggingMessageSecure(String string, String string2) {
        this.logHeading = string;
        this.id = string2;
    }

    public static String nextId() {
        return Integer.toString(ID.incrementAndGet());
    }

    public StringBuilder getAddress() {
        return this.address;
    }

    public StringBuilder getEncoding() {
        return this.encoding;
    }

    public StringBuilder getHeader() {
        return this.header;
    }

    public StringBuilder getContentType() {
        return this.contentType;
    }

    public StringBuilder getMessage() {
        return this.message;
    }

    public StringBuilder getPayload() {
        return this.payload;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.logHeading).append(" ID: ").append(this.id);
        if (this.address.length() > 0) {
            stringBuilder.append(this.logHeading).append(" Address: ");
            stringBuilder.append((CharSequence)this.address);
        }
        stringBuilder.append(this.logHeading).append(" Encoding: ");
        stringBuilder.append((CharSequence)this.encoding);
        stringBuilder.append(this.logHeading).append(" Content-Type: ");
        stringBuilder.append((CharSequence)this.contentType);
        stringBuilder.append(this.logHeading).append(" Headers:  ");
        stringBuilder.append((CharSequence)this.header);
        if (this.message.length() > 0) {
            stringBuilder.append("\nMessages: ");
            stringBuilder.append((CharSequence)this.message);
        }
        stringBuilder.append("\n");
        stringBuilder.append(this.logHeading).append("Payload: ");
        stringBuilder.append((CharSequence)this.formatPayload(this.payload));
        return stringBuilder.toString();
    }

    abstract StringBuilder formatPayload(StringBuilder var1);
}

