/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.impl.logging;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFormatter {
    private Document parseXmlString(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String prettyPrint(String string) {
        Object object;
        LSSerializer lSSerializer;
        DOMImplementationLS dOMImplementationLS;
        Document document = this.parseXmlString(string);
        DOMImplementation dOMImplementation = document.getImplementation();
        if (dOMImplementation.hasFeature("LS", "3.0") && dOMImplementation.hasFeature("Core", "2.0")) {
            dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
            lSSerializer = dOMImplementationLS.createLSSerializer();
            object = lSSerializer.getDomConfig();
            if (!object.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter can't be set. This method of pretty print requires JRE 1.6+");
            }
        } else {
            throw new RuntimeException("DOM 3.0 LS or DOM 2.0 Core feature(s) not supported. This method of pretty print requires JRE 1.6+");
        }
        lSSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        object = dOMImplementationLS.createLSOutput();
        object.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        object.setCharacterStream(stringWriter);
        lSSerializer.write(document, (LSOutput)object);
        return stringWriter.toString();
    }
}

