/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalDataContainerAdapter;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={InternalDataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        InternalDataContainer<Object, Object> dataContainer;
        if (this.configuration.dataContainer().dataContainer() != null) {
            return (T)new InternalDataContainerAdapter(this.configuration.dataContainer().dataContainer());
        }
        int level = this.configuration.locking().concurrencyLevel();
        MemoryConfiguration memoryConfiguration = this.configuration.memory();
        long thresholdSize = memoryConfiguration.size();
        EvictionStrategy strategy = memoryConfiguration.evictionStrategy();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            if (this.configuration.memory().storageType() == StorageType.OFF_HEAP) {
                return (T)new InternalDataContainerAdapter<WrappedBytes, WrappedBytes>(new OffHeapDataContainer(memoryConfiguration.addressCount()));
            }
            ClusteringConfiguration clusteringConfiguration = this.configuration.clustering();
            if (clusteringConfiguration.cacheMode().needsStateTransfer()) {
                int segments = clusteringConfiguration.hash().numSegments();
                if (clusteringConfiguration.l1().enabled()) {
                    return (T)new L1SegmentedDataContainer(segments);
                }
                return (T)new DefaultSegmentedDataContainer(segments);
            }
            return (T)DefaultDataContainer.unBoundedDataContainer(level);
        }
        if (memoryConfiguration.storageType() == StorageType.OFF_HEAP) {
            dataContainer = new InternalDataContainerAdapter<WrappedBytes, WrappedBytes>(new BoundedOffHeapDataContainer(memoryConfiguration.addressCount(), thresholdSize, memoryConfiguration.evictionType()));
        } else {
            ClusteringConfiguration clusteringConfiguration = this.configuration.clustering();
            if (clusteringConfiguration.cacheMode().needsStateTransfer()) {
                int segments = clusteringConfiguration.hash().numSegments();
                dataContainer = new BoundedSegmentedDataContainer(segments, thresholdSize, memoryConfiguration.evictionType());
            } else {
                dataContainer = DefaultDataContainer.boundedDataContainer(level, thresholdSize, memoryConfiguration.evictionType());
            }
        }
        this.configuration.eviction().attributes().attribute(EvictionConfiguration.SIZE).addListener((newSize, old) -> memoryConfiguration.size((Long)newSize.get()));
        memoryConfiguration.attributes().attribute(MemoryConfiguration.SIZE).addListener((newSize, old) -> dataContainer.resize((Long)newSize.get()));
        return (T)dataContainer;
    }
}

