/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage.http;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import netapp.manage.NaCertificateException;
import netapp.manage.NaSSLException;
import netapp.manage.http.HTTPClient;
import netapp.manage.http.HTTPException;

public abstract class HTTPMessage {
    public static final int VERSION_1_0 = 1;
    public static final int VERSION_1_1 = 2;
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    private static final byte[] CRLF = new byte[]{13, 10};
    protected int _version;
    protected Map _headerLowerCase;
    protected Map _header;
    protected byte[] _contents;

    protected HTTPMessage(int n) {
        this._version = n;
        this._headerLowerCase = new HashMap();
        this._header = new HashMap();
        this._contents = null;
    }

    public void setContents(byte[] byArray) {
        this._contents = byArray;
    }

    public byte[] getContents() {
        return this._contents;
    }

    private String fixHeaderKey(String string) {
        String string2 = (String)this._headerLowerCase.get(string.toLowerCase());
        if (null == string2) {
            this._headerLowerCase.put(string.toLowerCase(), string);
            string2 = string;
        }
        return string2;
    }

    public String getHeader(String string) {
        string = this.fixHeaderKey(string);
        return (String)this._header.get(string);
    }

    public void setHeader(String string, String string2) {
        string = this.fixHeaderKey(string);
        if (null == string2) {
            this._header.remove(string);
        } else {
            this._header.put(string, string2);
        }
    }

    public String removeHeader(String string) {
        string = this.fixHeaderKey(string);
        return (String)this._header.remove(string);
    }

    protected static int versionFromString(String string) throws HTTPException {
        if (string.equalsIgnoreCase("HTTP/1.0")) {
            return 1;
        }
        if (string.equalsIgnoreCase("HTTP/1.1")) {
            return 2;
        }
        throw new HTTPException("Invalid version: " + string);
    }

    protected static String versionToString(int n) {
        switch (n) {
            case 1: {
                return "HTTP/1.0";
            }
            case 2: {
                return "HTTP/1.1";
            }
        }
        return "";
    }

    protected static int methodFromString(String string) throws HTTPException {
        if (string.equalsIgnoreCase("GET")) {
            return 1;
        }
        if (string.equalsIgnoreCase("POST")) {
            return 2;
        }
        throw new HTTPException("Unknown method: " + string);
    }

    protected static String methodToString(int n) {
        switch (n) {
            case 1: {
                return "GET";
            }
            case 2: {
                return "POST";
            }
        }
        return "UNKNOWN";
    }

    protected static String readLine(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[128];
        int n = 0;
        while (true) {
            int n2;
            if (0 > (n2 = inputStream.read())) {
                if (false != n) break;
                throw new EOFException();
            }
            if (10 == n2) break;
            if (13 == n2) {
                n2 = inputStream.read();
                if (10 == n2) break;
                throw new IOException("Invalid line terminator");
            }
            byArray[n++] = (byte)n2;
            if (byArray.length >= n * 2) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        String string = new String(byArray, 0, n).trim();
        if (0 < HTTPClient.snoop) {
            System.err.println("Read Line === " + string);
        }
        return string;
    }

    protected void readContents(InputStream inputStream) throws IOException {
        String string = this.getHeader("Content-Length");
        if (null != string) {
            int n;
            int n2 = Integer.parseInt(string);
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
                if (0 <= n) continue;
                throw new EOFException("Encountered EOF at " + i + "/" + n2 + " bytes");
            }
            this.setContents(byArray);
        } else {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while (0 <= (n = inputStream.read(byArray))) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.setContents(byteArrayOutputStream.toByteArray());
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        block9: {
            byte[] byArray = this.toString().getBytes();
            int n = byArray.length + CRLF.length;
            if (null != this._contents) {
                n += this._contents.length;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(CRLF, 0, byArray2, byArray.length, CRLF.length);
            if (null != this._contents) {
                System.arraycopy(this._contents, 0, byArray2, byArray.length + CRLF.length, this._contents.length);
            }
            try {
                outputStream.write(byArray2);
            }
            catch (IOException iOException) {
                if (!(iOException.getCause() instanceof NaCertificateException)) break block9;
                NaCertificateException naCertificateException = (NaCertificateException)iOException.getCause();
                if (null != naCertificateException) {
                    throw new NaSSLException(naCertificateException.getCertificateChain(), naCertificateException.getMessage());
                }
                throw iOException;
            }
        }
        outputStream.flush();
        if (0 < HTTPClient.snoop) {
            String string;
            block10: {
                string = null;
                try {
                    if (null != this._contents) {
                        string = new String(this._contents, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (null == this._contents) break block10;
                    string = new String(this._contents);
                }
            }
            System.err.println("SENDING ======\n" + this.toString() + "\n" + string);
        }
    }

    protected void processHeaderLine(String string) throws HTTPException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new HTTPException("Invalid header line: " + string);
        }
        this._header.put(string.substring(0, n), string.substring(n + 1).trim());
    }

    protected abstract String firstLine();

    protected String headersString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : this._header.entrySet()) {
            Object k = entry.getKey();
            stringBuffer.append(k + ": " + this._header.get(k) + "\r\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.firstLine() + this.headersString();
    }
}

