/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.IVMWareService;
import com.netapp.collectors.vmware.VMWare25CsvService;
import com.netapp.collectors.vmware.VMWare25Service;
import com.netapp.collectors.vmware.exceptions.VMWareConfigurationException;
import com.netapp.collectors.vmware.logger.LogsManager;
import org.slf4j.Logger;

public class VMWareServiceFactory {
    private static String CSV_URL = ".rawdata";
    private static String SDK_URL = "sdk";
    private static String VIM_SERVICE_URL = "vimService";
    private static final Logger logger = LogsManager.getLogger(VMWareServiceFactory.class);

    public static IVMWareService getVMWareService(String url) {
        if (url.endsWith(CSV_URL)) {
            return VMWare25CsvService.getInstance();
        }
        if (url.endsWith(SDK_URL) || url.endsWith(VIM_SERVICE_URL)) {
            logger.info("Creating the vmware service for the url {} ", (Object)url);
            return VMWare25Service.getInstance();
        }
        logger.info("Unable to create vmware service for the url {}, reason - invalid URL ", (Object)url);
        throw new VMWareConfigurationException("Invalid URL for connecting to VIM service of VCenter.");
    }
}

