/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.VMWareDatastore;
import com.netapp.collectors.vmware.VMWareHost;
import com.netapp.collectors.vmware.VMWareResourcePool;
import com.netapp.collectors.vmware.VMWareVirtualDisk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VMWareVirtualMachine {
    private String name;
    private Object managedObject;
    private String powerState;
    private String connectionState;
    private String guestState;
    private String guestFamily;
    private String guestGuestFullName;
    private String configGuestFullName;
    private String toolsStatus;
    private String toolsVersion;
    private ArrayList<String> ipAddressList = new ArrayList();
    private String productName;
    private String uuid;
    private LinkedHashMap<Object, VMWareDatastore> dataStores = new LinkedHashMap();
    private LinkedHashMap<String, VMWareVirtualDisk> virtualDisks = new LinkedHashMap();
    private VMWareHost host;
    private VMWareResourcePool resourcePool;
    private String hostName;
    private int numberOfCpu;
    private int numSamples;
    private float cpuUsedMHz;
    private float cpuUsedAvg;
    private float cpuReady;
    private float cpuReadyMs;
    private long memorySwapOutAvg;
    private long memorySwapInAvg;
    private float memoryBalloon;
    private float memoryBalloonTarget;
    private float memoryConsumedAvg;
    private long cpuShares;
    private long cpuLimit;
    private long cpuReservation;
    private long memoryShares;
    private long memoryLimit;
    private long memoryReservation;
    private float avgNetworkUsage;
    private Map<VMWareDatastore, Float> capacityTotal = new HashMap<VMWareDatastore, Float>();
    private Map<VMWareDatastore, Float> capacityTotalMBs = new HashMap<VMWareDatastore, Float>();
    private Map<VMWareDatastore, Float> vmdkTotal = new HashMap<VMWareDatastore, Float>();
    private Map<VMWareDatastore, Float> vmdkTotalMBs = new HashMap<VMWareDatastore, Float>();
    private ArrayList<Object> scsiLUNs = new ArrayList();
    private HashMap<String, Object> lunStats = new HashMap();
    private String cpuShareLevel;
    private String memoryShareLevel;
    private long memoryMB;
    private ArrayList<String> vmdkFolderPaths = new ArrayList();
    private String logDirectory;
    private String snapshotDirectory;
    private String suspendDirectory;
    private String vmPathName;
    private Set<String> folders = new HashSet<String>();
    private String guestId;
    private Object[] virtualDevice;
    private Object[] fileLayoutDiskLayout;
    private String vmHardwareVersion;
    private HashMap<String, String> extraConfig = new HashMap();
    private boolean isTemplate;
    private boolean isPrimary = false;
    private boolean isSecondary = false;

    public VMWareVirtualMachine(Object managedObject) {
        this.managedObject = managedObject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getManagedObject() {
        return this.managedObject;
    }

    public void setManagedObject(Object managedObject) {
        this.managedObject = managedObject;
    }

    public String getPowerState() {
        return this.powerState;
    }

    public void setPowerState(String powerState) {
        this.powerState = powerState;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public String getGuestState() {
        return this.guestState;
    }

    public void setGuestState(String guestState) {
        this.guestState = guestState;
    }

    public String getGuestFamily() {
        return this.guestFamily;
    }

    public void setGuestFamily(String guestFamily) {
        this.guestFamily = guestFamily;
    }

    public String getGuestGuestFullName() {
        return this.guestGuestFullName;
    }

    public void setGuestGuestFullName(String guestGuestFullName) {
        this.guestGuestFullName = guestGuestFullName;
    }

    public String getConfigGuestFullName() {
        return this.configGuestFullName;
    }

    public void setConfigGuestFullName(String configGuestFullName) {
        this.configGuestFullName = configGuestFullName;
    }

    public String getToolsStatus() {
        return this.toolsStatus;
    }

    public void setToolsStatus(String toolsStatus) {
        this.toolsStatus = toolsStatus;
    }

    public String getToolsVersion() {
        return this.toolsVersion;
    }

    public void setToolsVersion(String toolsVersion) {
        this.toolsVersion = toolsVersion;
    }

    public ArrayList<String> getIpAddressList() {
        return this.ipAddressList;
    }

    public void setIpAddressList(ArrayList<String> ipAddressList) {
        this.ipAddressList = ipAddressList;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public VMWareDatastore getDatastores(Object key) {
        return this.dataStores.get(key);
    }

    public void putDataStores(Object key, VMWareDatastore dataStore) {
        this.dataStores.put(key, dataStore);
    }

    public LinkedHashMap<Object, VMWareDatastore> getAllDataStores() {
        return this.dataStores;
    }

    public void setAllDataStores(LinkedHashMap<Object, VMWareDatastore> datastores) {
        this.dataStores = datastores;
    }

    public VMWareVirtualDisk getVirtualDisk(String scsiId) {
        return this.virtualDisks.get(scsiId);
    }

    public void putVirtualDisk(String scsiId, VMWareVirtualDisk virtualDisk) {
        this.virtualDisks.put(scsiId, virtualDisk);
    }

    public LinkedHashMap<String, VMWareVirtualDisk> getAllVirtualDisks() {
        return this.virtualDisks;
    }

    public void setAllVirtualDisks(LinkedHashMap<String, VMWareVirtualDisk> virtualDisks) {
        this.virtualDisks = virtualDisks;
    }

    public VMWareHost getHost() {
        return this.host;
    }

    public void setHost(VMWareHost host) {
        this.host = host;
    }

    public VMWareResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(VMWareResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public int getNumberOfCpu() {
        return this.numberOfCpu;
    }

    public void setNumberOfCpu(int numberOfCpu) {
        this.numberOfCpu = numberOfCpu;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public float getCpuUsedMHz() {
        return this.cpuUsedMHz;
    }

    public void setCpuUsedMHz(float cpuUsedMHz) {
        this.cpuUsedMHz = cpuUsedMHz;
    }

    public float getCpuUsedAvg() {
        return this.cpuUsedAvg;
    }

    public void setCpuUsedAvg(float cpuUsedAvg) {
        this.cpuUsedAvg = cpuUsedAvg;
    }

    public float getCpuReady() {
        return this.cpuReady;
    }

    public void setCpuReady(float cpuReady) {
        this.cpuReady = cpuReady;
    }

    public float getCpuReadyMs() {
        return this.cpuReadyMs;
    }

    public void setCpuReadyMs(float cpuReadyMs) {
        this.cpuReadyMs = cpuReadyMs;
    }

    public long getMemorySwapOutAvg() {
        return this.memorySwapOutAvg;
    }

    public void setMemorySwapOutAvg(long memorySwapOutAvg) {
        this.memorySwapOutAvg = memorySwapOutAvg;
    }

    public long getMemorySwapInAvg() {
        return this.memorySwapInAvg;
    }

    public void setMemorySwapInAvg(long memorySwapInAvg) {
        this.memorySwapInAvg = memorySwapInAvg;
    }

    public float getMemoryBalloonAvg() {
        return this.memoryBalloon;
    }

    public void setMemoryBalloonAvg(float memoryVmMemCtlAvg) {
        this.memoryBalloon = memoryVmMemCtlAvg;
    }

    public float getMemoryBalloonTargetAvg() {
        return this.memoryBalloonTarget;
    }

    public void setMemoryBalloonTargetAvg(float memoryVmMemCtlTargetAvg) {
        this.memoryBalloonTarget = memoryVmMemCtlTargetAvg;
    }

    public float getMemoryConsumedAvg() {
        return this.memoryConsumedAvg;
    }

    public void setMemoryConsumedAvg(float memoryConsumedAvg) {
        this.memoryConsumedAvg = memoryConsumedAvg;
    }

    public long getCpuShares() {
        return this.cpuShares;
    }

    public void setCpuShares(long cpuShares) {
        this.cpuShares = cpuShares;
    }

    public long getCpuLimit() {
        return this.cpuLimit;
    }

    public void setCpuLimit(long cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public long getCpuReservation() {
        return this.cpuReservation;
    }

    public void setCpuReservation(long cpuReservation) {
        this.cpuReservation = cpuReservation;
    }

    public long getMemoryShares() {
        return this.memoryShares;
    }

    public void setMemoryShares(long memoryShares) {
        this.memoryShares = memoryShares;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public long getMemoryReservation() {
        return this.memoryReservation;
    }

    public void setMemoryReservation(long memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public Float getAvgNetworkUsage() {
        return Float.valueOf(this.avgNetworkUsage);
    }

    public void setAvgNetworkUsage(Float avgNetworkUsage) {
        this.avgNetworkUsage = avgNetworkUsage.floatValue();
    }

    public Float getCapacityTotal(VMWareDatastore dataStore) {
        return this.capacityTotal.get(dataStore);
    }

    public void addCapacityTotal(VMWareDatastore dataStore, Float capacityTotal) {
        Float currentCapacity = this.getCapacityTotal(dataStore);
        currentCapacity = this.addTotals(capacityTotal, currentCapacity);
        this.capacityTotal.put(dataStore, currentCapacity);
    }

    private Float addTotals(Float newValue, Float currentValue) {
        currentValue = currentValue != null ? Float.valueOf(currentValue.floatValue() + newValue.floatValue()) : newValue;
        return currentValue;
    }

    public Float getCapacityTotalMBs(VMWareDatastore dataStore) {
        return this.capacityTotalMBs.get(dataStore);
    }

    public void addCapacityTotalMBs(VMWareDatastore dataStore, Float capacityTotalMBs) {
        Float currentCapacityMBs = this.getCapacityTotalMBs(dataStore);
        currentCapacityMBs = this.addTotals(capacityTotalMBs, currentCapacityMBs);
        this.capacityTotalMBs.put(dataStore, currentCapacityMBs);
    }

    public Float getVmdkTotal(VMWareDatastore dataStore) {
        return this.vmdkTotal.get(dataStore);
    }

    public void addVmdkTotal(VMWareDatastore dataStore, Float vmdkTotal) {
        Float currentVMDKTotal = this.getVmdkTotal(dataStore);
        currentVMDKTotal = this.addTotals(vmdkTotal, currentVMDKTotal);
        this.vmdkTotal.put(dataStore, currentVMDKTotal);
    }

    public Float getVmdkTotalMBs(VMWareDatastore dataStore) {
        return this.vmdkTotalMBs.get(dataStore);
    }

    public void addVmdkTotalMBs(VMWareDatastore dataStore, Float vmdkTotalMBs) {
        Float currentVMDKTotalMBs = this.getVmdkTotalMBs(dataStore);
        currentVMDKTotalMBs = this.addTotals(vmdkTotalMBs, currentVMDKTotalMBs);
        this.vmdkTotalMBs.put(dataStore, currentVMDKTotalMBs);
    }

    public ArrayList<Object> getAllScsiLUNs() {
        return this.scsiLUNs;
    }

    public void putScsiLUN(Object scsiLUN) {
        this.scsiLUNs.add(scsiLUN);
    }

    public Object getLunStats(String conanicalName) {
        return this.lunStats.get(conanicalName);
    }

    public void putLunStats(String conanicalName, Object stats) {
        this.lunStats.put(conanicalName, stats);
    }

    public String getCpuShareLevel() {
        return this.cpuShareLevel;
    }

    public void setCpuShareLevel(String cpuShareLevel) {
        this.cpuShareLevel = cpuShareLevel;
    }

    public String getMemoryShareLevel() {
        return this.memoryShareLevel;
    }

    public void setMemoryShareLevel(String memoryShareLevel) {
        this.memoryShareLevel = memoryShareLevel;
    }

    public long getMemoryMB() {
        return this.memoryMB;
    }

    public void setMemoryMB(long memoryMB) {
        this.memoryMB = memoryMB;
    }

    public ArrayList<String> getVMDKFolderPaths() {
        return this.vmdkFolderPaths;
    }

    public String getVMDKFolderPath(int i) {
        return this.vmdkFolderPaths.get(i);
    }

    public void setVMDKFolderPath(ArrayList<String> diskLayoutFilePaths) {
        this.vmdkFolderPaths = diskLayoutFilePaths;
        for (String path : diskLayoutFilePaths) {
            if (path.lastIndexOf("/") != -1) {
                this.folders.add(path.substring(0, path.lastIndexOf("/")));
                continue;
            }
            this.folders.add(path.substring(0, path.lastIndexOf("]") + 1));
        }
    }

    public void addVMDKFolderPath(String diskLayoutFilePath) {
        this.vmdkFolderPaths.add(diskLayoutFilePath);
        if (diskLayoutFilePath.lastIndexOf("/") != -1) {
            this.folders.add(diskLayoutFilePath.substring(0, diskLayoutFilePath.lastIndexOf("/")));
        } else {
            this.folders.add(diskLayoutFilePath.substring(0, diskLayoutFilePath.lastIndexOf("]") + 1));
        }
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
        this.folders.add(logDirectory);
    }

    public String getSnapshotDirectory() {
        return this.snapshotDirectory;
    }

    public void setSnapshotDirectory(String snapshotDirectory) {
        this.snapshotDirectory = snapshotDirectory;
        this.folders.add(snapshotDirectory);
    }

    public String getSuspendDirectory() {
        return this.suspendDirectory;
    }

    public void setSuspendDirectory(String suspendDirectory) {
        this.suspendDirectory = suspendDirectory;
        this.folders.add(suspendDirectory);
    }

    public String getVmPathName() {
        return this.vmPathName;
    }

    public void setVmPathName(String vmPathName) {
        this.vmPathName = vmPathName;
        this.folders.add(vmPathName);
    }

    public List<String> getFolderPathsForDatastore(String datastoreName) {
        ArrayList<String> folderPaths = new ArrayList<String>();
        for (String path : this.folders) {
            if (!path.contains(datastoreName)) continue;
            folderPaths.add(path);
        }
        return folderPaths;
    }

    public String getGuestId() {
        return this.guestId;
    }

    public void setGuestId(String guestId) {
        this.guestId = guestId;
    }

    public Object[] getVirtualDevice() {
        return this.virtualDevice;
    }

    public void setVirtualDevice(Object[] virtualDevice) {
        this.virtualDevice = virtualDevice;
    }

    public Object[] getFileLayoutDiskLayout() {
        return this.fileLayoutDiskLayout;
    }

    public void setFileLayoutDiskLayout(Object[] fileLayoutDiskLayout) {
        this.fileLayoutDiskLayout = fileLayoutDiskLayout;
    }

    public String getVmHardwareVersion() {
        return this.vmHardwareVersion;
    }

    public void setVmHardwareVersion(String vmHardwareVersion) {
        this.vmHardwareVersion = vmHardwareVersion;
    }

    public HashMap<String, String> getExtraConfig() {
        return this.extraConfig;
    }

    public void setExtraConfig(HashMap<String, String> extraConfig) {
        this.extraConfig = extraConfig;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public boolean isSecondary() {
        return this.isSecondary;
    }

    public void setSecondary(boolean isSecondary) {
        this.isSecondary = isSecondary;
    }

    public String toString() {
        String NEWLINE = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append(NEWLINE);
        sb.append("name = " + this.name + NEWLINE);
        sb.append("hostname = " + this.hostName + NEWLINE);
        sb.append("powerstate = " + this.powerState + NEWLINE);
        sb.append("gueststate = " + this.guestState + NEWLINE);
        sb.append("guestfamily = " + this.guestFamily + NEWLINE);
        sb.append("toolsStatus = " + this.toolsStatus + NEWLINE);
        sb.append("toolsVersion = " + this.toolsVersion + NEWLINE);
        sb.append("productname = " + this.productName + NEWLINE);
        sb.append("vmHwVersion = " + this.vmHardwareVersion + NEWLINE);
        sb.append("uuid = " + this.uuid + NEWLINE);
        sb.append("numcpu = " + this.numberOfCpu + NEWLINE);
        sb.append("memoryMB = " + this.memoryMB + NEWLINE);
        sb.append("guestid = " + this.guestId + NEWLINE);
        sb.append("cpushare = " + this.cpuShareLevel + NEWLINE);
        sb.append("memshare = " + this.memoryShareLevel + NEWLINE);
        sb.append("istemplate = " + this.isTemplate + NEWLINE);
        sb.append("cpuReady = " + this.cpuReady + NEWLINE);
        sb.append("cpuReadyMs = " + this.cpuReadyMs + NEWLINE);
        sb.append("memoryBalloon = " + this.memoryBalloon + NEWLINE);
        sb.append("cpushares = " + this.cpuShares + NEWLINE);
        sb.append("cpulimit = " + this.cpuLimit + NEWLINE);
        sb.append("cpures = " + this.cpuReservation + NEWLINE);
        sb.append("memshares = " + this.cpuShares + NEWLINE);
        sb.append("memlimit = " + this.cpuLimit + NEWLINE);
        sb.append("memres = " + this.cpuReservation + NEWLINE);
        sb.append("IPs = " + this.ipAddressList + NEWLINE);
        sb.append("host = " + this.host + NEWLINE);
        sb.append("respool = " + this.resourcePool + NEWLINE);
        sb.append(NEWLINE);
        return sb.toString();
    }
}

