/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;

public class BackportReusePublicIdentifiers
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public BackportReusePublicIdentifiers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (cls.getMajor() >= 49) {
            super.visitClassContext(classContext);
        }
    }

    public void sawOpcode(int seen) {
        this.stack.precomputation((DismantleBytecode)this);
        switch (seen) {
            case 184: {
                String className = this.getClassConstantOperand();
                if (!className.startsWith("edu/emory/mathcs/backport/")) break;
                this.reportBug();
                break;
            }
            case 183: {
                String className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if (!className.startsWith("edu/emory/mathcs/backport/") || !methodName.equals("<init>")) break;
                this.reportBug();
            }
        }
    }

    private void reportBug() {
        this.bugReporter.reportBug(new BugInstance((Detector)this, "BRPI_BACKPORT_REUSE_PUBLIC_IDENTIFIERS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }
}

