/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariableTable;

public class CommonsEqualsBuilderToEquals
extends BytecodeScanningDetector {
    private final OpcodeStack stack = new OpcodeStack();
    private final BugReporter bugReporter;

    public CommonsEqualsBuilderToEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            switch (seen) {
                case 182: {
                    String methodName = this.getNameConstantOperand();
                    if (!"equals".equals(methodName)) return;
                    if (!"(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand())) return;
                    if (this.stack.getStackDepth() <= 1) return;
                    String calledClass = this.stack.getStackItem(1).getSignature();
                    if (!"Lorg/apache/commons/lang3/builder/EqualsBuilder;".equals(calledClass)) {
                        if (!"Lorg/apache/commons/lang/builder/EqualsBuilder;".equals(calledClass)) return;
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "CEBE_COMMONS_EQUALS_BUILDER_ISEQUALS", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            super.sawOpcode(seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

