/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariableTable;

@OpcodeStack.CustomUserValue
public class CompareClassNameEquals
extends OpcodeStackDetector {
    private boolean flag = false;
    private final BugReporter bugReporter;

    public CompareClassNameEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public boolean shouldVisitCode(Code obj) {
        this.flag = false;
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        return lvt != null;
    }

    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if (this.flag) {
            this.stack.getStackItem(0).setUserValue((Object)Boolean.TRUE);
            this.flag = false;
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: {
                if ("getName".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand()) && "java/lang/Class".equals(this.getClassConstantOperand())) {
                    this.flag = true;
                    break;
                }
                if (!"equals".equals(this.getNameConstantOperand()) || !"(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand()) || !"java/lang/String".equals(this.getClassConstantOperand())) break;
                OpcodeStack.Item item = this.stack.getItemMethodInvokedOn((DismantleBytecode)this);
                Object srcValue = item.getUserValue();
                item = this.stack.getStackItem(0);
                Object dstValue = item.getUserValue();
                if (!Boolean.TRUE.equals(srcValue) || !Boolean.TRUE.equals(dstValue)) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CCNE_COMPARE_CLASS_EQUALS_NAME", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }
}

