/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class ConfusingArrayAsList
extends BytecodeScanningDetector {
    private static Set<String> PRIMITIVE_ARRAYS = new HashSet<String>(8);
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public ConfusingArrayAsList(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item item;
            String sig;
            String methodName;
            String clsName;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 184 && "java/util/Arrays".equals(clsName = this.getClassConstantOperand()) && "asList".equals(methodName = this.getNameConstantOperand()) && this.stack.getStackDepth() == 1 && PRIMITIVE_ARRAYS.contains(sig = (item = this.stack.getStackItem(0)).getSignature())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CAAL_CONFUSING_ARRAY_AS_LIST", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    static {
        PRIMITIVE_ARRAYS.add("[[B");
        PRIMITIVE_ARRAYS.add("[[C");
        PRIMITIVE_ARRAYS.add("[[S");
        PRIMITIVE_ARRAYS.add("[[I");
        PRIMITIVE_ARRAYS.add("[[J");
        PRIMITIVE_ARRAYS.add("[[F");
        PRIMITIVE_ARRAYS.add("[[D");
        PRIMITIVE_ARRAYS.add("[[Z");
    }
}

