/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;

public class IncorrectInternalClassUse
implements Detector {
    private final BugReporter bugReporter;
    private static final Set<String> internalPackages = new HashSet<String>();
    private static final Set<String> externalPackages = new HashSet<String>();

    public IncorrectInternalClassUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext context) {
        JavaClass cls = context.getJavaClass();
        if (!this.isInternal(cls.getClassName())) {
            ConstantPool pool = cls.getConstantPool();
            int numItems = pool.getLength();
            for (int i = 0; i < numItems; ++i) {
                String clsName;
                Constant c = pool.getConstant(i);
                if (!(c instanceof ConstantClass) || !this.isInternal(clsName = ((ConstantClass)c).getBytes(pool))) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "IICU_INCORRECT_INTERNAL_CLASS_USE", 2).addClass(cls).addString(clsName));
            }
        }
    }

    public void report() {
    }

    private boolean isInternal(String clsName) {
        boolean internal = false;
        for (String internalPackage : internalPackages) {
            if (!clsName.startsWith(internalPackage)) continue;
            internal = true;
            break;
        }
        if (internal) {
            for (String externalPackage : externalPackages) {
                if (!clsName.startsWith(externalPackage)) continue;
                internal = false;
                break;
            }
        }
        return internal;
    }

    static {
        internalPackages.add("com/sun/");
        internalPackages.add("org/apache/xerces/");
        internalPackages.add("org/apache/xalan/");
        externalPackages.add("com/sun/jersey");
        externalPackages.add("com/sun/xml/xsom");
        externalPackages.add("org/apache/xerces/xni/");
        externalPackages.add("org/apache/xerces/xs/");
        externalPackages.add("org/apache/xalan/extensions");
    }
}

