/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class InheritanceTypeChecking
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private Set<IfStatement> ifStatements;

    public InheritanceTypeChecking(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.ifStatements = new HashSet<IfStatement>();
            super.visitClassContext(classContext);
        }
        finally {
            this.ifStatements = null;
        }
    }

    public void visitCode(Code obj) {
        this.ifStatements.clear();
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        boolean processed = false;
        Iterator<IfStatement> isi = this.ifStatements.iterator();
        while (isi.hasNext()) {
            IfStatement.Action action = isi.next().processOpcode(this, this.bugReporter, seen);
            if (action == IfStatement.Action.REMOVE_ACTION) {
                isi.remove();
                continue;
            }
            if (action != IfStatement.Action.PROCESSED_ACTION) continue;
            processed = true;
        }
        if (!processed && (seen == 25 || seen >= 42 && seen <= 45)) {
            IfStatement is = new IfStatement(this, seen);
            this.ifStatements.add(is);
        }
    }

    private static class IfStatement {
        private State state = State.SEEN_ALOAD;
        private int reg;
        private int firstPC;
        private int branchTarget;
        private int matchCount;
        private Set<String> instanceOfTypes;

        public IfStatement(BytecodeScanningDetector bsd, int seen) {
            this.reg = RegisterUtils.getALoadReg((DismantleBytecode)bsd, seen);
            this.matchCount = 0;
            this.firstPC = bsd.getPC();
        }

        public Action processOpcode(BytecodeScanningDetector bsd, BugReporter bugReporter, int seen) {
            switch (this.state) {
                case SEEN_ALOAD: {
                    if (seen != 193) break;
                    if (this.instanceOfTypes == null) {
                        this.instanceOfTypes = new HashSet<String>();
                    }
                    this.instanceOfTypes.add(bsd.getClassConstantOperand());
                    this.state = State.SEEN_INSTANCEOF;
                    return Action.PROCESSED_ACTION;
                }
                case SEEN_INSTANCEOF: {
                    if (seen != 153) break;
                    this.branchTarget = bsd.getBranchTarget();
                    this.state = State.SEEN_IFEQ;
                    ++this.matchCount;
                    return Action.PROCESSED_ACTION;
                }
                case SEEN_IFEQ: {
                    if (bsd.getPC() == this.branchTarget) {
                        if ((seen == 25 || seen >= 42 && seen <= 45) && this.reg == RegisterUtils.getALoadReg((DismantleBytecode)bsd, seen)) {
                            this.state = State.SEEN_ALOAD;
                            return Action.PROCESSED_ACTION;
                        }
                        if (this.matchCount > 1) {
                            String clsName = bsd.getClassName();
                            int priority = 2;
                            for (String type : this.instanceOfTypes) {
                                if (SignatureUtils.similarPackages(clsName, type, 2)) continue;
                                priority = 3;
                                break;
                            }
                            bugReporter.reportBug(new BugInstance((Detector)bsd, "ITC_INHERITANCE_TYPE_CHECKING", priority).addClass((PreorderVisitor)bsd).addMethod((PreorderVisitor)bsd).addSourceLine(bsd, this.firstPC));
                            return Action.REMOVE_ACTION;
                        }
                    }
                    return Action.NO_ACTION;
                }
            }
            return Action.REMOVE_ACTION;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            SEEN_ALOAD,
            SEEN_INSTANCEOF,
            SEEN_IFEQ;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Action {
            NO_ACTION,
            REMOVE_ACTION,
            PROCESSED_ACTION;

        }
    }
}

