/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class ListIndexedIterating
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<ForLoop> possibleForLoops;
    private Stage stage;
    private State state;
    private int loopReg;
    private boolean sawListSize;

    public ListIndexedIterating(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.possibleForLoops = new HashSet<ForLoop>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.possibleForLoops = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(132) && (bytecodeSet.get(167) || bytecodeSet.get(200));
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (this.prescreen(m)) {
            this.sawListSize = false;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = State.SAW_NOTHING;
            this.stage = Stage.FIND_LOOP_STAGE;
            super.visitCode(obj);
            if (this.sawListSize) {
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                this.state = State.SAW_NOTHING;
                this.stage = Stage.FIND_BUG_STAGE;
                super.visitCode(obj);
            }
        }
    }

    public void sawOpcode(int seen) {
        if (this.stage == Stage.FIND_LOOP_STAGE) {
            this.sawOpcodeLoop(seen);
        } else {
            this.sawOpcodeBug(seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawOpcodeLoop(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            switch (this.state) {
                case SAW_NOTHING: {
                    if (seen != 132 || this.getIntConstant() != 1) break;
                    this.loopReg = this.getRegisterOperand();
                    this.state = State.SAW_IINC;
                    break;
                }
                case SAW_IINC: {
                    int pc;
                    int branchTarget;
                    if ((seen == 167 || seen == 200) && (branchTarget = this.getBranchTarget()) < (pc = this.getPC())) {
                        this.possibleForLoops.add(new ForLoop(branchTarget, pc, this.loopReg));
                    }
                    this.state = State.SAW_NOTHING;
                }
            }
            if (seen == 185 && "java/util/List".equals(this.getClassConstantOperand()) && "size".equals(this.getNameConstantOperand()) && "()I".equals(this.getSigConstantOperand())) {
                this.sawListSize = true;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawOpcodeBug(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            Iterator<ForLoop> it = this.possibleForLoops.iterator();
            while (it.hasNext()) {
                ForLoop fl = it.next();
                switch (fl.getLoopState()) {
                    case LOOP_NOT_STARTED: {
                        if (this.getPC() != fl.getLoopStart()) break;
                        if ((seen == 21 || seen >= 26 && seen <= 29) && this.getReg(seen, 21, 26) == fl.getLoopReg()) {
                            fl.setLoopState(LoopState.LOOP_INDEX_LOADED_FOR_TEST);
                            break;
                        }
                        it.remove();
                        break;
                    }
                    case LOOP_INDEX_LOADED_FOR_TEST: {
                        OpcodeStack.Item itm;
                        if (this.getPC() >= fl.getLoopEnd()) {
                            it.remove();
                            break;
                        }
                        if (seen != 162) break;
                        if (this.stack.getStackDepth() > 1 && (itm = this.stack.getStackItem(0)).getConstant() != null) {
                            it.remove();
                            break;
                        }
                        int branchTarget = this.getBranchTarget();
                        if (branchTarget < fl.getLoopEnd() + 3 || branchTarget > fl.getLoopEnd() + 5) break;
                        fl.setLoopState(LoopState.LOOP_IN_BODY);
                        break;
                    }
                    case LOOP_IN_BODY: 
                    case LOOP_IN_BODY_WITH_GET: {
                        boolean sawGet;
                        if (this.getPC() == fl.getLoopEnd() && fl.getLoopState() == LoopState.LOOP_IN_BODY_WITH_GET) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LII_LIST_INDEXED_ITERATING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLineRange((BytecodeScanningDetector)this, fl.getLoopStart(), fl.getLoopEnd()));
                            it.remove();
                        }
                        if (this.getPC() > fl.getLoopEnd()) {
                            it.remove();
                        }
                        if (seen == 21 || seen >= 26 && seen <= 29) {
                            this.loopReg = this.getReg(seen, 21, 26);
                            if (this.loopReg != fl.getLoopReg()) break;
                            fl.setLoopRegLoaded(true);
                            break;
                        }
                        if (!fl.getLoopRegLoaded()) break;
                        boolean bl = sawGet = seen == 185 && "java/util/List".equals(this.getClassConstantOperand()) && "get".equals(this.getNameConstantOperand()) && "(I)Ljava/lang/Object;".equals(this.getSigConstantOperand());
                        if (!sawGet) {
                            it.remove();
                            break;
                        }
                        fl.setLoopState(LoopState.LOOP_IN_BODY_WITH_GET);
                        if (this.stack.getStackDepth() > 1) {
                            OpcodeStack.Item itm = this.stack.getStackItem(0);
                            if (!itm.couldBeZero()) {
                                it.remove();
                            } else {
                                itm = this.stack.getStackItem(1);
                                if (fl.isSecondItem(itm)) {
                                    it.remove();
                                }
                            }
                        }
                        fl.setLoopRegLoaded(false);
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private int getReg(int seen, int generalOp, int zeroOp) {
        if (seen == generalOp) {
            return this.getRegisterOperand();
        }
        return seen - zeroOp;
    }

    static class ForLoop {
        private int loopStart;
        private int loopEnd;
        private int loopReg;
        private LoopState loopState;
        private boolean loopRegLoaded;
        private OpcodeStack.Item loopCollectionItem;

        public ForLoop(int start, int end, int reg) {
            this.loopStart = start;
            this.loopEnd = end;
            this.loopReg = reg;
            this.loopState = LoopState.LOOP_NOT_STARTED;
            this.loopRegLoaded = false;
            this.loopCollectionItem = null;
        }

        public int getLoopStart() {
            return this.loopStart;
        }

        public int getLoopEnd() {
            return this.loopEnd;
        }

        public int getLoopReg() {
            return this.loopReg;
        }

        public void setLoopState(LoopState state) {
            this.loopState = state;
        }

        public LoopState getLoopState() {
            return this.loopState;
        }

        public void setLoopRegLoaded(boolean loaded) {
            this.loopRegLoaded = loaded;
        }

        public boolean getLoopRegLoaded() {
            return this.loopRegLoaded;
        }

        public boolean isSecondItem(OpcodeStack.Item itm) {
            if (this.loopCollectionItem == null) {
                this.loopCollectionItem = itm;
                return false;
            }
            int seenReg = this.loopCollectionItem.getRegisterNumber();
            if (seenReg >= 0) {
                if (itm.getXField() != null) {
                    return true;
                }
                int newReg = itm.getRegisterNumber();
                if (newReg >= 0 && seenReg != newReg) {
                    return true;
                }
            } else {
                XField seenField = this.loopCollectionItem.getXField();
                if (seenField != null) {
                    if (itm.getRegisterNumber() >= 0) {
                        return true;
                    }
                    XField newField = itm.getXField();
                    if (newField != null && !newField.getName().equals(seenField.getName())) {
                        return true;
                    }
                }
            }
            this.loopCollectionItem = itm;
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Stage {
        FIND_LOOP_STAGE,
        FIND_BUG_STAGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LoopState {
        LOOP_NOT_STARTED,
        LOOP_INDEX_LOADED_FOR_TEST,
        LOOP_IN_BODY,
        LOOP_IN_BODY_WITH_GET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SAW_NOTHING,
        SAW_IINC;

    }
}

