/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class LiteralStringComparison
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public LiteralStringComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(18) || bytecodeSet.get(19));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 && "java/lang/String".equals(this.getClassConstantOperand())) {
                OpcodeStack.Item itm;
                Object constant;
                String calledMethodName = this.getNameConstantOperand();
                String calledMethodSig = this.getSigConstantOperand();
                if (("equals".equals(calledMethodName) && "(Ljava/lang/Object;)Z".equals(calledMethodSig) || "compareTo".equals(calledMethodName) && "(Ljava/lang/String;)I".equals(calledMethodSig) || "equalsIgnoreCase".equals(calledMethodName) && "(Ljava/lang/String;)Z".equals(calledMethodSig)) && this.stack.getStackDepth() > 0 && (constant = (itm = this.stack.getStackItem(0)).getConstant()) != null && constant.getClass().equals(String.class)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "LSC_LITERAL_STRING_COMPARISON", 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

