/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class LocalSynchronizedCollection
extends BytecodeScanningDetector {
    private static Map<String, Integer> syncCtors = new HashMap<String, Integer>();
    private static Set<String> syncMethods;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, CollectionRegInfo> syncRegs;
    private int classVersion;

    public LocalSynchronizedCollection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.syncRegs = new HashMap<Integer, CollectionRegInfo>();
            this.classVersion = classContext.getJavaClass().getMajor();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.syncRegs = null;
        }
    }

    public void visitMethod(Method obj) {
        int[] parmRegs;
        this.syncRegs.clear();
        for (int pr : parmRegs = RegisterUtils.getParameterRegisters(obj)) {
            this.syncRegs.put(pr, new CollectionRegInfo(RegisterUtils.getLocalVariableEndRange(obj.getLocalVariableTable(), pr, 0)));
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
        for (Map.Entry<Integer, CollectionRegInfo> entry : this.syncRegs.entrySet()) {
            CollectionRegInfo cri = entry.getValue();
            if (cri.getIgnore()) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "LSYC_LOCAL_SYNCHRONIZED_COLLECTION", cri.getPriority()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(cri.getSourceLineAnnotation()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Integer tosIsSyncColReg = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 183) {
                Integer minVersion;
                if ("<init>".equals(this.getNameConstantOperand()) && (minVersion = syncCtors.get(this.getClassConstantOperand())) != null && this.classVersion >= minVersion) {
                    tosIsSyncColReg = -1;
                }
            } else if (seen == 184) {
                if ("java/util/Collections".equals(this.getClassConstantOperand()) && syncMethods.contains(this.getNameConstantOperand())) {
                    tosIsSyncColReg = -1;
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78) {
                if (this.stack.getStackDepth() > 0) {
                    CollectionRegInfo cri;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (item.getUserValue() != null) {
                        if (!this.syncRegs.containsKey(reg)) {
                            cri = new CollectionRegInfo(SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this), RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg, this.getNextPC()));
                            this.syncRegs.put(reg, cri);
                        }
                    } else {
                        cri = this.syncRegs.get(reg);
                        if (cri == null) {
                            cri = new CollectionRegInfo(RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg, this.getNextPC()));
                            this.syncRegs.put(reg, cri);
                        }
                        cri.setIgnore();
                    }
                }
            } else if (seen == 25 || seen >= 42 && seen <= 45) {
                int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                CollectionRegInfo cri = this.syncRegs.get(reg);
                if (cri != null && !cri.getIgnore()) {
                    tosIsSyncColReg = reg;
                }
            } else if ((seen == 181 || seen == 176) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                this.syncRegs.remove(item.getUserValue());
            }
            if (this.syncRegs.size() > 0) {
                if (seen == 183 || seen == 185 || seen == 182 || seen == 184) {
                    String sig = this.getSigConstantOperand();
                    int argCount = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() >= argCount) {
                        for (int i = 0; i < argCount; ++i) {
                            OpcodeStack.Item item = this.stack.getStackItem(i);
                            CollectionRegInfo cri = this.syncRegs.get(item.getUserValue());
                            if (cri == null) continue;
                            cri.setPriority(3);
                        }
                    }
                } else if (seen == 194) {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        this.syncRegs.remove(item.getUserValue());
                    }
                } else if (seen == 83 && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.syncRegs.remove(item.getUserValue());
                }
            }
            int curPC = this.getPC();
            Iterator<CollectionRegInfo> it = this.syncRegs.values().iterator();
            while (it.hasNext()) {
                CollectionRegInfo cri = it.next();
                if (cri.getEndPCRange() >= curPC) continue;
                if (!cri.getIgnore()) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "LSYC_LOCAL_SYNCHRONIZED_COLLECTION", cri.getPriority()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(cri.getSourceLineAnnotation()));
                }
                it.remove();
            }
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (tosIsSyncColReg != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)tosIsSyncColReg);
            }
        }
    }

    static {
        syncCtors.put("java/util/Vector", 45);
        syncCtors.put("java/util/Hashtable", 45);
        syncCtors.put("java/lang/StringBuffer", 49);
        syncMethods = new HashSet<String>();
        syncMethods.add("synchronizedCollection");
        syncMethods.add("synchronizedList");
        syncMethods.add("synchronizedMap");
        syncMethods.add("synchronizedSet");
        syncMethods.add("synchronizedSortedMap");
        syncMethods.add("synchronizedSortedSet");
    }

    static class CollectionRegInfo {
        private SourceLineAnnotation slAnnotation;
        private int priority = 1;
        private int endPCRange = Integer.MAX_VALUE;

        public CollectionRegInfo(SourceLineAnnotation sla, int endPC) {
            this.slAnnotation = sla;
            this.endPCRange = endPC;
        }

        public CollectionRegInfo(int endPC) {
            this.slAnnotation = null;
            this.endPCRange = endPC;
        }

        public SourceLineAnnotation getSourceLineAnnotation() {
            return this.slAnnotation;
        }

        public void setEndPCRange(int pc) {
            this.endPCRange = pc;
        }

        public int getEndPCRange() {
            return this.endPCRange;
        }

        public void setIgnore() {
            this.slAnnotation = null;
        }

        public boolean getIgnore() {
            return this.slAnnotation == null;
        }

        public void setPriority(int newPriority) {
            if (newPriority > this.priority) {
                this.priority = newPriority;
            }
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

