/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class LoggerOddities
extends BytecodeScanningDetector {
    private static JavaClass THROWABLE_CLASS;
    private static Set<String> LOGGER_METHODS;
    private static Pattern BAD_FORMATTING_ANCHOR;
    private static Pattern FORMATTER_ANCHOR;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String clsName;

    public LoggerOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.clsName = classContext.getJavaClass().getClassName();
            int subclassIndex = this.clsName.indexOf(36);
            while (subclassIndex >= 0) {
                String simpleName = this.clsName.substring(subclassIndex + 1);
                try {
                    Integer.parseInt(simpleName);
                    this.clsName = this.clsName.substring(0, subclassIndex);
                    subclassIndex = this.clsName.indexOf(36);
                }
                catch (NumberFormatException nfe) {
                    subclassIndex = -1;
                }
            }
            this.clsName = this.clsName.replace('.', '/');
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        Method m = this.getMethod();
        if ("<init>".equals(m.getName())) {
            Type[] types;
            for (Type t : types = Type.getArgumentTypes((String)m.getSignature())) {
                String parmSig = t.getSignature();
                if (!"Lorg/slf4j/Logger;".equals(parmSig) && !"Lorg/apache/log4j/Logger;".equals(parmSig) && !"Lorg/apache/commons/logging/Log;".equals(parmSig)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_SUSPECT_LOG_PARAMETER", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        String ldcClassName = null;
        int exMessageReg = -1;
        Integer arraySize = null;
        try {
            block42: {
                try {
                    OpcodeStack.Item arrayItem;
                    Integer size;
                    block43: {
                        boolean isAnonClassPrefix;
                        String loggingClassName;
                        block45: {
                            OpcodeStack.Item item;
                            String signature;
                            String mthName;
                            String callingClsName;
                            block46: {
                                block47: {
                                    block44: {
                                        OpcodeStack.Item item2;
                                        this.stack.precomputation((DismantleBytecode)this);
                                        if (seen == 18 || seen == 19) {
                                            Constant c = this.getConstantRefOperand();
                                            if (c instanceof ConstantClass) {
                                                ConstantPool pool = this.getConstantPool();
                                                ldcClassName = ((ConstantUtf8)pool.getConstant(((ConstantClass)c).getNameIndex())).getBytes();
                                            }
                                            break block42;
                                        }
                                        if (seen != 184) break block43;
                                        callingClsName = this.getClassConstantOperand();
                                        mthName = this.getNameConstantOperand();
                                        loggingClassName = null;
                                        if (!"org/slf4j/LoggerFactory".equals(callingClsName) || !"getLogger".equals(mthName)) break block44;
                                        signature = this.getSigConstantOperand();
                                        if ("(Ljava/lang/Class;)Lorg/slf4j/Logger;".equals(signature)) {
                                            if (this.stack.getStackDepth() > 0) {
                                                OpcodeStack.Item item22 = this.stack.getStackItem(0);
                                                loggingClassName = (String)item22.getUserValue();
                                            }
                                            break block45;
                                        } else if ("(Ljava/lang/String;)Lorg/slf4j/Logger;".equals(signature) && this.stack.getStackDepth() > 0 && (loggingClassName = (String)(item2 = this.stack.getStackItem(0)).getConstant()) != null) {
                                            loggingClassName = loggingClassName.replace('.', '/');
                                        }
                                        break block45;
                                    }
                                    if (!"org/apache/log4j/Logger".equals(callingClsName) || !"getLogger".equals(mthName)) break block46;
                                    signature = this.getSigConstantOperand();
                                    if (!"(Ljava/lang/Class;)Lorg/apache/log4j/Logger;".equals(signature)) break block47;
                                    if (this.stack.getStackDepth() > 0) {
                                        item = this.stack.getStackItem(0);
                                        loggingClassName = (String)item.getUserValue();
                                    }
                                    break block45;
                                }
                                if ("(Ljava/lang/String;)Lorg/apache/log4j/Logger;".equals(signature)) {
                                    if (this.stack.getStackDepth() > 0 && (loggingClassName = (String)(item = this.stack.getStackItem(0)).getConstant()) != null) {
                                        loggingClassName = loggingClassName.replace('.', '/');
                                    }
                                    break block45;
                                } else if ("(Ljava/lang/String;Lorg/apache/log4j/spi/LoggerFactory;)Lorg/apache/log4j/Logger;".equals(signature) && this.stack.getStackDepth() > 1 && (loggingClassName = (String)(item = this.stack.getStackItem(1)).getConstant()) != null) {
                                    loggingClassName = loggingClassName.replace('.', '/');
                                }
                                break block45;
                            }
                            if ("org/apache/commons/logging/LogFactory".equals(callingClsName) && "getLog".equals(mthName)) {
                                signature = this.getSigConstantOperand();
                                if ("(Ljava/lang/Class;)Lorg/apache/commons/logging/Log;".equals(signature)) {
                                    if (this.stack.getStackDepth() > 0) {
                                        item = this.stack.getStackItem(0);
                                        loggingClassName = (String)item.getUserValue();
                                    }
                                } else if ("(Ljava/lang/String;)Lorg/apache/commons/logging/Log;".equals(signature) && this.stack.getStackDepth() > 0 && (loggingClassName = (String)(item = this.stack.getStackItem(0)).getConstant()) != null) {
                                    loggingClassName = loggingClassName.replace('.', '/');
                                }
                            }
                        }
                        if (loggingClassName == null || this.stack.getStackDepth() <= 0 || loggingClassName.equals(this.clsName)) break block42;
                        boolean isPrefix = this.clsName.startsWith(loggingClassName);
                        if (isPrefix) {
                            String anonClass = this.clsName.substring(loggingClassName.length());
                            isAnonClassPrefix = anonClass.matches("(\\$\\d+)+");
                        } else {
                            isAnonClassPrefix = false;
                        }
                        if (!isAnonClassPrefix) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_SUSPECT_LOG_CLASS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                        break block42;
                    }
                    if ((seen == 182 || seen == 185) && THROWABLE_CLASS != null) {
                        OpcodeStack.Item formatItem;
                        Object con;
                        String signature;
                        String callingClsName;
                        String mthName = this.getNameConstantOperand();
                        if (mthName.equals("getMessage")) {
                            String callingClsName2 = this.getClassConstantOperand();
                            JavaClass cls = Repository.lookupClass((String)callingClsName2);
                            if (cls.instanceOf(THROWABLE_CLASS) && this.stack.getStackDepth() > 0) {
                                OpcodeStack.Item exItem = this.stack.getStackItem(0);
                                exMessageReg = exItem.getRegisterNumber();
                            }
                            break block42;
                        }
                        if (!LOGGER_METHODS.contains(mthName) || !(callingClsName = this.getClassConstantOperand()).endsWith("Log") && !callingClsName.endsWith("Logger")) break block42;
                        String sig = this.getSigConstantOperand();
                        if ("(Ljava/lang/String;Ljava/lang/Throwable;)V".equals(sig) || "(Ljava/lang/Object;Ljava/lang/Throwable;)V".equals(sig)) {
                            if (this.stack.getStackDepth() < 2) break block42;
                            OpcodeStack.Item exItem = this.stack.getStackItem(0);
                            OpcodeStack.Item msgItem = this.stack.getStackItem(1);
                            Integer exReg = (Integer)msgItem.getUserValue();
                            if (exReg != null && exReg.intValue() == exItem.getRegisterNumber()) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_STUTTERED_MESSAGE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            break block42;
                        }
                        if ("(Ljava/lang/Object;)V".equals(sig)) {
                            JavaClass clazz;
                            if (this.stack.getStackDepth() > 0 && (clazz = this.stack.getStackItem(0).getJavaClass()) != null && clazz.instanceOf(THROWABLE_CLASS)) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_LOGGER_LOST_EXCEPTION_STACK_TRACE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            break block42;
                        }
                        if (!"org/slf4j/Logger".equals(callingClsName) || !"(Ljava/lang/String;Ljava/lang/Object;)V".equals(signature = this.getSigConstantOperand()) && !"(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V".equals(signature) && !"(Ljava/lang/String;[Ljava/lang/Object;)V".equals(signature)) break block42;
                        int numParms = Type.getArgumentTypes((String)signature).length;
                        if (this.stack.getStackDepth() < numParms || !((con = (formatItem = this.stack.getStackItem(numParms - 1)).getConstant()) instanceof String)) break block42;
                        Matcher m = BAD_FORMATTING_ANCHOR.matcher((String)con);
                        if (m.find()) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_INVALID_FORMATTING_ANCHOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break block42;
                        }
                        int actualParms = this.getSLF4JParmCount(signature);
                        if (actualParms == -1) break block42;
                        int expectedParms = this.countAnchors((String)con);
                        boolean hasEx = this.hasExceptionOnStack();
                        if (!hasEx && expectedParms != actualParms || hasEx && expectedParms != actualParms - 1 && expectedParms != actualParms) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_INCORRECT_NUMBER_OF_ANCHOR_PARAMETERS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("Expected: " + expectedParms).addString("Actual: " + actualParms));
                        }
                        break block42;
                    }
                    if (seen == 183) {
                        String sig;
                        Type[] types;
                        String cls;
                        if (!"<init>".equals(this.getNameConstantOperand()) || !(cls = this.getClassConstantOperand()).startsWith("java/") && !cls.startsWith("javax/") || !cls.endsWith("Exception") || (types = Type.getArgumentTypes((String)(sig = this.getSigConstantOperand()))).length > this.stack.getStackDepth()) break block42;
                        for (int i = 0; i < types.length; ++i) {
                            OpcodeStack.Item item3;
                            String cons;
                            if (!"Ljava/lang/String;".equals(types[i].getSignature()) || (cons = (String)(item3 = this.stack.getStackItem(types.length - i - 1)).getConstant()) == null || !cons.contains("{}")) continue;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_EXCEPTION_WITH_LOGGER_PARMS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break block42;
                        }
                        break block42;
                    }
                    if (seen == 189) {
                        OpcodeStack.Item sizeItem;
                        Object con;
                        if (this.stack.getStackDepth() > 0 && (con = (sizeItem = this.stack.getStackItem(0)).getConstant()) instanceof Integer) {
                            arraySize = (Integer)con;
                        }
                        break block42;
                    }
                    if (seen != 83 || this.stack.getStackDepth() < 3 || (size = (Integer)(arrayItem = this.stack.getStackItem(2)).getUserValue()) == null || size <= 0 || !this.hasExceptionOnStack()) break block42;
                    Integer sz = -size.intValue();
                    arrayItem.setUserValue((Object)sz);
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var17_46 = null;
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (ldcClassName != null && this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item4 = this.stack.getStackItem(0);
                        item4.setUserValue((Object)ldcClassName);
                    }
                    if (exMessageReg >= 0 && this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item3 = this.stack.getStackItem(0);
                        item3.setUserValue((Object)exMessageReg);
                    }
                    if (arraySize == null) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue(arraySize);
                    return;
                }
            }
            Object var17_45 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (ldcClassName != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item4 = this.stack.getStackItem(0);
                item4.setUserValue((Object)ldcClassName);
            }
            if (exMessageReg >= 0 && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item3 = this.stack.getStackItem(0);
                item3.setUserValue((Object)exMessageReg);
            }
            if (arraySize == null) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)arraySize);
            return;
        }
        catch (Throwable throwable) {
            Object var17_47 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (ldcClassName != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item4 = this.stack.getStackItem(0);
                item4.setUserValue((Object)ldcClassName);
            }
            if (exMessageReg >= 0 && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item3 = this.stack.getStackItem(0);
                item3.setUserValue((Object)exMessageReg);
            }
            if (arraySize == null) throw throwable;
            if (this.stack.getStackDepth() <= 0) throw throwable;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue(arraySize);
            throw throwable;
        }
    }

    private int countAnchors(String formatString) {
        Matcher m = FORMATTER_ANCHOR.matcher(formatString);
        int count = 0;
        int start = 0;
        while (m.find(start)) {
            ++count;
            start = m.end();
        }
        return count;
    }

    private int getSLF4JParmCount(String signature) {
        if ("(Ljava/lang/String;Ljava/lang/Object;)V".equals(signature)) {
            return 1;
        }
        if ("(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V".equals(signature)) {
            return 2;
        }
        OpcodeStack.Item item = this.stack.getStackItem(0);
        Integer size = (Integer)item.getUserValue();
        if (size != null) {
            return Math.abs(size);
        }
        return -1;
    }

    private boolean hasExceptionOnStack() {
        try {
            for (int i = 0; i < this.stack.getStackDepth() - 1; ++i) {
                Integer sz;
                String name;
                JavaClass cls;
                OpcodeStack.Item item = this.stack.getStackItem(i);
                String sig = item.getSignature();
                if (!(sig.startsWith("L") ? (cls = Repository.lookupClass((String)(name = sig.substring(1, sig.length() - 1)))).instanceOf(THROWABLE_CLASS) : sig.startsWith("[") && (sz = (Integer)item.getUserValue()) != null && sz < 0)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return true;
        }
    }

    static {
        BAD_FORMATTING_ANCHOR = Pattern.compile("\\{[0-9]\\}");
        FORMATTER_ANCHOR = Pattern.compile("\\{\\}");
        try {
            THROWABLE_CLASS = Repository.lookupClass((String)"java/lang/Throwable");
            LOGGER_METHODS = new HashSet<String>();
            LOGGER_METHODS.add("trace");
            LOGGER_METHODS.add("debug");
            LOGGER_METHODS.add("info");
            LOGGER_METHODS.add("warn");
            LOGGER_METHODS.add("error");
            LOGGER_METHODS.add("fatal");
        }
        catch (ClassNotFoundException cnfe) {
            THROWABLE_CLASS = null;
        }
    }
}

