/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class ManualArrayCopy
extends BytecodeScanningDetector {
    private static final BitSet arrayLoadOps = new BitSet();
    private BugReporter bugReporter;
    private State state;
    private int arrayIndexReg;
    private int loadInstruction;

    public ManualArrayCopy(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.intersects(arrayLoadOps);
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.state = State.SAW_NOTHING;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SAW_NOTHING: {
                if (seen != 162 && seen != 163) break;
                this.state = State.SAW_ICMP;
                break;
            }
            case SAW_ICMP: {
                if (seen != 25 && (seen < 42 || seen > 45)) break;
                this.state = State.SAW_ARRAY1_LOAD;
                break;
            }
            case SAW_ARRAY1_LOAD: {
                if (seen == 21) {
                    this.arrayIndexReg = this.getRegisterOperand();
                    this.state = State.SAW_ARRAY1_INDEX;
                    break;
                }
                if (seen >= 26 && seen <= 29) {
                    this.arrayIndexReg = seen - 26;
                    this.state = State.SAW_ARRAY1_INDEX;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_ARRAY1_INDEX: {
                if (seen == 25 || seen >= 42 && seen <= 45) {
                    this.state = State.SAW_ARRAY2_LOAD;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_ARRAY2_LOAD: {
                if (seen == 21) {
                    if (this.arrayIndexReg == this.getRegisterOperand()) {
                        this.state = State.SAW_ARRAY2_INDEX;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                if (seen >= 26 && seen <= 29) {
                    if (this.arrayIndexReg == seen - 26) {
                        this.state = State.SAW_ARRAY2_INDEX;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_ARRAY2_INDEX: {
                if (seen == 50 || seen == 51 || seen == 52 || seen == 53 || seen == 46 || seen == 47 || seen == 49 || seen == 48) {
                    this.loadInstruction = seen;
                    this.state = State.SAW_ELEM_LOAD;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_ELEM_LOAD: {
                if (seen == 83 || seen == 84 || seen == 85 || seen == 86 || seen == 79 || seen == 80 || seen == 82 || seen == 81) {
                    if (this.similarArrayInstructions(this.loadInstruction, seen)) {
                        this.state = State.SAW_ELEM_STORE;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_ELEM_STORE: {
                if (seen == 132) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "MAC_MANUAL_ARRAY_COPY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = State.SAW_NOTHING;
            }
        }
    }

    private boolean similarArrayInstructions(int load, int store) {
        if (load == 50 && store == 83) {
            return true;
        }
        if (load == 46 && store == 79) {
            return true;
        }
        if (load == 49 && store == 82) {
            return true;
        }
        if (load == 47 && store == 80) {
            return true;
        }
        if (load == 48 && store == 81) {
            return true;
        }
        if (load == 51 && store == 84) {
            return true;
        }
        if (load == 52 && store == 85) {
            return true;
        }
        return load == 53 && store == 86;
    }

    static {
        arrayLoadOps.set(50);
        arrayLoadOps.set(51);
        arrayLoadOps.set(52);
        arrayLoadOps.set(53);
        arrayLoadOps.set(46);
        arrayLoadOps.set(47);
        arrayLoadOps.set(49);
        arrayLoadOps.set(48);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SAW_NOTHING,
        SAW_ICMP,
        SAW_ARRAY1_LOAD,
        SAW_ARRAY1_INDEX,
        SAW_ARRAY2_LOAD,
        SAW_ARRAY2_INDEX,
        SAW_ELEM_LOAD,
        SAW_ELEM_STORE;

    }
}

