/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class MethodReturnsConstant
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private int returnRegister;
    private Map<Integer, Object> registerConstants;
    private Object returnConstant;
    private boolean methodSuspect;
    private int returnPC;

    public MethodReturnsConstant(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.registerConstants = new HashMap<Integer, Object>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.registerConstants = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.registerConstants = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        int aFlags = m.getAccessFlags();
        if (!((aFlags & 2) == 0 && (aFlags & 8) == 0 || (aFlags & 0x1000) != 0 || m.getSignature().endsWith(")Z"))) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.returnRegister = -1;
            this.returnConstant = null;
            this.registerConstants.clear();
            this.methodSuspect = true;
            this.returnPC = -1;
            super.visitCode(obj);
            if (this.methodSuspect && this.returnConstant != null) {
                BugInstance bi = new BugInstance((Detector)this, "MRC_METHOD_RETURNS_CONSTANT", (aFlags & 2) != 0 ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                if (this.returnPC >= 0) {
                    bi.addSourceLine((BytecodeScanningDetector)this, this.returnPC);
                }
                bi.addString(this.returnConstant.toString());
                this.bugReporter.reportBug(bi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        boolean sawSBToString;
        block18: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                sawSBToString = false;
                                try {
                                    Object constant;
                                    int register;
                                    block24: {
                                        block23: {
                                            if (!this.methodSuspect) {
                                                Object var7_3 = null;
                                                break block17;
                                            }
                                            this.stack.precomputation((DismantleBytecode)this);
                                            if (seen >= 172 && seen <= 176) {
                                                if (this.stack.getStackDepth() <= 0) break block18;
                                                OpcodeStack.Item item = this.stack.getStackItem(0);
                                                int register2 = item.getRegisterNumber();
                                                if (this.registerConstants.containsKey(register2) && this.registerConstants.get(register2) == null) {
                                                    this.methodSuspect = false;
                                                    break block19;
                                                }
                                                Object constant2 = item.getConstant();
                                                if (constant2 == null) {
                                                    this.methodSuspect = false;
                                                    break block20;
                                                }
                                                if (Boolean.TRUE.equals(item.getUserValue()) && "".equals(constant2)) {
                                                    this.methodSuspect = false;
                                                    break block21;
                                                }
                                                if (this.returnConstant != null && !this.returnConstant.equals(constant2)) {
                                                    this.methodSuspect = false;
                                                    break block22;
                                                }
                                                this.returnRegister = item.getRegisterNumber();
                                                this.returnConstant = constant2;
                                                break block18;
                                            }
                                            if (seen == 167 || seen == 200) {
                                                if (this.stack.getStackDepth() > 0) {
                                                    this.methodSuspect = false;
                                                }
                                                break block18;
                                            }
                                            if (seen == 182) {
                                                String clsName = this.getClassConstantOperand();
                                                if (clsName.startsWith("java/lang/StringB")) {
                                                    sawSBToString = "toString".equals(this.getNameConstantOperand());
                                                }
                                                break block18;
                                            }
                                            if ((seen < 54 || seen > 78) && seen != 132) break block18;
                                            register = this.getRegisterOperand();
                                            if (this.returnRegister != -1 && register == this.returnRegister) {
                                                this.methodSuspect = false;
                                            }
                                            if (this.stack.getStackDepth() <= 0) break block23;
                                            OpcodeStack.Item item = this.stack.getStackItem(0);
                                            Object constant3 = item.getConstant();
                                            if (this.registerConstants.containsKey(register)) {
                                                if (constant3 == null || !constant3.equals(this.registerConstants.get(register))) {
                                                    this.registerConstants.put(register, null);
                                                }
                                                break block24;
                                            } else {
                                                this.registerConstants.put(register, constant3);
                                            }
                                            break block24;
                                        }
                                        this.registerConstants.put(register, null);
                                    }
                                    if (this.returnRegister == register && (constant = this.registerConstants.get(this.returnRegister)) != null) {
                                        this.methodSuspect = false;
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    Object var7_9 = null;
                                    TernaryPatcher.pre(this.stack, seen);
                                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                                    TernaryPatcher.post(this.stack, seen);
                                    if (!sawSBToString) throw throwable;
                                    if (this.stack.getStackDepth() <= 0) throw throwable;
                                    OpcodeStack.Item item = this.stack.getStackItem(0);
                                    item.setUserValue((Object)Boolean.TRUE);
                                    throw throwable;
                                }
                            }
                            TernaryPatcher.pre(this.stack, seen);
                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                            TernaryPatcher.post(this.stack, seen);
                            if (!sawSBToString) return;
                            if (this.stack.getStackDepth() <= 0) return;
                            OpcodeStack.Item item = this.stack.getStackItem(0);
                            item.setUserValue((Object)Boolean.TRUE);
                            return;
                        }
                        Object var7_4 = null;
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (!sawSBToString) return;
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)Boolean.TRUE);
                        return;
                    }
                    Object var7_5 = null;
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (!sawSBToString) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)Boolean.TRUE);
                    return;
                }
                Object var7_6 = null;
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (!sawSBToString) return;
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
                return;
            }
            Object var7_7 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (!sawSBToString) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)Boolean.TRUE);
            return;
        }
        Object var7_8 = null;
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (!sawSBToString) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        item.setUserValue((Object)Boolean.TRUE);
    }
}

