/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.Type;

public class NeedlessInstanceRetrieval
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private LineNumberTable lnTable;
    private State state;
    private int invokePC;
    private String returnType;

    public NeedlessInstanceRetrieval(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            this.lnTable = obj.getLineNumberTable();
            if (this.lnTable != null) {
                this.state = State.SEEN_NOTHING;
                this.invokePC = -1;
                this.returnType = null;
                super.visitCode(obj);
            }
            Object var3_2 = null;
            this.lnTable = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lnTable = null;
            throw throwable;
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SEEN_NOTHING: {
                String clsName;
                String sig;
                Type retType;
                if (seen != 185 && seen != 182 || !(retType = Type.getReturnType((String)(sig = this.getSigConstantOperand()))).getSignature().startsWith("L") || "java/lang/Object".equals(clsName = this.getClassConstantOperand()) || "java/lang/String".equals(clsName)) break;
                this.returnType = retType.getSignature();
                this.returnType = this.returnType.substring(1, this.returnType.length() - 1);
                this.invokePC = this.getPC();
                this.state = State.SEEN_INVOKE;
                break;
            }
            case SEEN_INVOKE: {
                if (seen == 87) {
                    this.state = State.SEEN_POP;
                    break;
                }
                this.state = State.SEEN_NOTHING;
                this.returnType = null;
                break;
            }
            case SEEN_POP: {
                if (seen >= 1 && seen <= 15 || seen == 180) {
                    this.state = State.SEEN_POP;
                    break;
                }
                if (seen == 184 || seen == 178) {
                    if (this.getClassConstantOperand().equals(this.returnType) && this.lnTable.getSourceLine(this.invokePC) == this.lnTable.getSourceLine(this.getPC())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NIR_NEEDLESS_INSTANCE_RETRIEVAL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SEEN_NOTHING;
                    this.returnType = null;
                    break;
                }
                this.state = State.SEEN_NOTHING;
                this.returnType = null;
                break;
            }
            default: {
                this.state = State.SEEN_NOTHING;
                this.returnType = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SEEN_NOTHING,
        SEEN_INVOKE,
        SEEN_POP;

    }
}

