/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class NonOwnedSynchronization
extends BytecodeScanningDetector {
    private static final Integer OWNED = Integer.MAX_VALUE;
    private static final Integer LOW = 3;
    private static final Integer NORMAL = 2;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> regPriorities;

    public NonOwnedSynchronization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.regPriorities = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.regPriorities = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.regPriorities = null;
            throw throwable;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(194);
    }

    public void visitCode(Code obj) {
        Method method = this.getMethod();
        if (this.prescreen(method)) {
            int[] parmRegs;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.regPriorities.clear();
            for (int reg : parmRegs = RegisterUtils.getParameterRegisters(method)) {
                this.regPriorities.put(reg, NORMAL);
            }
            if (!method.isStatic()) {
                this.regPriorities.put(0, LOW);
            }
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Integer tosIsPriority = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 180: {
                    tosIsPriority = OWNED;
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (this.getMethod().isStatic() && reg == 0) {
                        tosIsPriority = LOW;
                        break;
                    }
                    tosIsPriority = this.regPriorities.get(reg);
                    if (tosIsPriority == null) {
                        tosIsPriority = NORMAL;
                    }
                    break;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Integer priority = (Integer)item.getUserValue();
                    this.regPriorities.put(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen), priority);
                    break;
                }
                case 182: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (t.getSignature().startsWith("L")) {
                        int parmCnt = Type.getArgumentTypes((String)sig).length;
                        if (this.stack.getStackDepth() > parmCnt) {
                            OpcodeStack.Item itm = this.stack.getStackItem(parmCnt);
                            Integer priority = (Integer)itm.getUserValue();
                            if (priority != null && OWNED.equals(priority)) {
                                tosIsPriority = OWNED;
                                break;
                            }
                            int reg = itm.getRegisterNumber();
                            if (reg > 0) {
                                tosIsPriority = this.regPriorities.get(reg);
                                break;
                            }
                            tosIsPriority = OWNED;
                        }
                    }
                    break;
                }
                case 184: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (t.getSignature().startsWith("L")) {
                        tosIsPriority = OWNED;
                    }
                    break;
                }
                case 183: {
                    String name = this.getNameConstantOperand();
                    if ("<init>".equals(name)) {
                        tosIsPriority = OWNED;
                    }
                    break;
                }
                case 194: {
                    OpcodeStack.Item itm;
                    Integer priority;
                    if (this.stack.getStackDepth() <= 0 || (priority = (Integer)(itm = this.stack.getStackItem(0)).getUserValue()) == null || priority.equals(OWNED)) break;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NOS_NON_OWNED_SYNCHRONIZATION", priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            Object var10_17 = null;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (tosIsPriority != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)tosIsPriority);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (tosIsPriority != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            itm.setUserValue((Object)tosIsPriority);
        }
    }
}

